/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.command;

import com.google.common.io.Files;
import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.confluent.command.CommandUtil;
import io.confluent.command.cluster_metadata.CommandClusterMetadata;
import io.confluent.command.kafka.CommandStore;
import io.confluent.command.record.Command;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.command.CommandMigrator;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.util.LruSet;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(CommandModule.class);
    public static final String CP_COMMAND = "cp-command";
    public static final String COMMAND = "command";

    protected void configure() {
    }

    @Provides
    @Inject
    @CommandTopic
    protected TopicStoreMaster.Topic<Command.CommandKey, Command.CommandMessage, Void, Void> getCommandTopic(ControlCenterConfig config) {
        return new TopicStoreMaster.Topic<Command.CommandKey, Command.CommandMessage, Void, Void>(config.getString("confluent.controlcenter.command.topic"), null, CommandUtil.commandKeySerde, CommandUtil.commandMessageSerde, false);
    }

    @Provides
    @Inject
    @CommandStateDir
    protected Path getCommandStateDir(ControlCenterConfig controlCenterConfig) throws IOException {
        Path commandStateDir = Paths.get(controlCenterConfig.getString("confluent.controlcenter.data.dir"), controlCenterConfig.getString("confluent.controlcenter.id"), CP_COMMAND);
        Files.createParentDirs((File)commandStateDir.toFile());
        return commandStateDir;
    }

    @Provides
    @Inject
    @CommandStoreStreamsConfig
    protected StreamsConfig provideCommandStreamsConfig(ControlCenterConfig controlCenterConfig, @CommandStateDir Path commandStateDir, ControlCenterRbacConfig rbacConfig) {
        String streamsAppId = TopicStoreMaster.nameJoin(controlCenterConfig.getString("confluent.controlcenter.name"), ControlCenterConfig.CONTROL_CENTER_VERSION, controlCenterConfig.getString("confluent.controlcenter.id"), COMMAND);
        return CommandModule.getStreamsConfig(streamsAppId, controlCenterConfig, commandStateDir, rbacConfig);
    }

    @Provides
    @Inject
    @Singleton
    protected CommandStore provideCommandStore(@CommandStoreStreamsConfig StreamsConfig streamsConfig, ControlCenterConfig controlCenterConfig) throws TimeoutException, InterruptedException {
        return CommandModule.getCommandStore(streamsConfig, controlCenterConfig);
    }

    @Provides
    @ExporterCommandStore
    @Singleton
    protected CommandStore provideCommandStoreForExport(ControlCenterConfig controlCenterConfig, @CommandStateDir Path commandStateDir, ControlCenterRbacConfig rbacConfig) throws TimeoutException, InterruptedException {
        String streamsAppId = TopicStoreMaster.nameJoin(controlCenterConfig.getString("confluent.controlcenter.name"), ControlCenterConfig.CONTROL_CENTER_VERSION, controlCenterConfig.getString("confluent.controlcenter.id"), "command-exporter");
        StreamsConfig streamsConfig = CommandModule.getStreamsConfig(streamsAppId, controlCenterConfig, commandStateDir, rbacConfig);
        return CommandModule.getCommandStore(streamsConfig, controlCenterConfig);
    }

    @Provides
    @Inject
    @Singleton
    @TriggerConfigs
    protected ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage> provideTriggerConfigs(CommandStore commandStore) {
        return commandStore.getStore(Command.CommandConfigType.MONITORING_TRIGGER_CONFIG);
    }

    @Provides
    @Inject
    @Singleton
    @ActionConfigs
    protected ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage> provideActionConfigs(CommandStore commandStore) {
        return commandStore.getStore(Command.CommandConfigType.ACTION_CONFIG);
    }

    @Provides
    @Inject
    @Singleton
    @ClusterMetadataStore
    protected ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage> provideClusterMetadata(CommandStore commandStore) {
        return commandStore.getStore(Command.CommandConfigType.CLUSTER_METADATA);
    }

    @Provides
    @Inject
    @Singleton
    @ExporterClusterMetadataStore
    protected ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage> provideClusterMetadataForExport(@ExporterCommandStore CommandStore commandStore) {
        return commandStore.getStore(Command.CommandConfigType.CLUSTER_METADATA);
    }

    @Provides
    @Inject
    @Singleton
    @CommandStoreMigrator
    protected CommandMigrator provideCommandMigration(@ClusterMetadataStore Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> clusterMetadataStore, CommandStore commandStore, LruSet<CommandClusterMetadata.KafkaClusterMetadata> clusters) {
        return new CommandMigrator(clusterMetadataStore, commandStore, clusters);
    }

    @NotNull
    private static CommandStore getCommandStore(StreamsConfig streamsConfig, ControlCenterConfig controlCenterConfig) {
        return new CommandStore.Builder().topic(controlCenterConfig.getString("confluent.controlcenter.command.topic")).streamsConfig(streamsConfig).producerConfig(streamsConfig.getProducerConfigs("c3-command")).build();
    }

    @NotNull
    private static StreamsConfig getStreamsConfig(String streamsAppId, ControlCenterConfig controlCenterConfig, Path commandStateDir, ControlCenterRbacConfig rbacConfig) {
        Properties props = new Properties();
        props.put("bootstrap.servers", controlCenterConfig.getList("bootstrap.servers"));
        props.put("state.dir", commandStateDir.toString());
        props.put("application.id", streamsAppId);
        props.put(StreamsConfig.producerPrefix((String)"max.request.size"), (Object)0xA00000);
        props.putAll(controlCenterConfig.valuesWithPrefix("confluent.controlcenter.streams."));
        props.putAll(controlCenterConfig.originalsWithPrefix("confluent.controlcenter.streams."));
        props.put(StreamsConfig.consumerPrefix((String)"auto.offset.reset"), "earliest");
        props.put(StreamsConfig.producerPrefix((String)"acks"), "all");
        props.put("num.stream.threads", "1");
        props.put("cache.max.bytes.buffering", (Object)0);
        props.put("topology.optimization", "all");
        rbacConfig.putAllIfAbsentRbacControlCenterConfigs(props);
        return new StreamsConfig((Map)props);
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ExporterClusterMetadataStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ClusterMetadataStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface CommandStoreMigrator {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ActionConfigs {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface TriggerConfigs {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ExporterCommandStore {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface CommandStoreStreamsConfig {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface CommandStateDir {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface CommandTopic {
    }
}

