/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.connect;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ClusterMetadata;
import io.confluent.controlcenter.StaticClusterConfigSupplier;
import io.confluent.controlcenter.httpclient.HttpCredential;
import io.confluent.controlcenter.rest.ControlCenterRestModule;
import io.confluent.controlcenter.rest.res.ConnectCluster;
import io.confluent.controlcenter.util.ConfigUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConnectClusterMetadata
extends ClusterMetadata<ConnectCluster> {
    private static final Logger log = LoggerFactory.getLogger(ConnectClusterMetadata.class);

    @Inject
    public ConnectClusterMetadata(@ControlCenterRestModule.ConnectClusterConfigSupplier StaticClusterConfigSupplier connectClusterConfigSupplier) {
        this.addClusters(connectClusterConfigSupplier.getConfigurations());
    }

    @Override
    protected ConnectCluster createCluster(String displayName, Map<String, Object> config) {
        List<String> endpoints = ConfigUtils.getList(config, "cluster");
        if (this.checkInvalidEndpoints(endpoints)) {
            log.error("No valid cluster urls specified for connect cluster '{}'", (Object)displayName);
            return null;
        }
        HttpCredential credential = this.createCredential(displayName, config);
        return new ConnectCluster(displayName, displayName, endpoints, credential);
    }

    @Override
    protected void addCluster(ConnectCluster cluster) {
        Preconditions.checkNotNull((Object)cluster);
        this.clusters.add(cluster);
        this.endpointsLookup.put(cluster.getClusterId(), cluster.getEndpoints());
        if (cluster.getCredential() != null) {
            this.credentialsLookup.put(cluster.getClusterId(), cluster.getCredential());
        }
    }
}

