/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.data.PermissionsService;
import io.confluent.controlcenter.rest.res.AllPermissionsResponse;
import io.confluent.controlcenter.rest.res.AuthorizedOperations;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Scope;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractPermissionsService
implements PermissionsService {
    private static final String SINGLE_LOOKUP_KEY = "KEY";

    @Override
    public abstract AllPermissionsResponse getAllOperations(JwtPrincipal var1);

    @Override
    public Set<String> getAllVisibleClusters(JwtPrincipal principal) {
        return this.getAllOperations(principal).getScoped().keySet();
    }

    @Override
    public Set<PermissionsService.ControlCenterOperation> getAllScopedOperations(JwtPrincipal principal, String clusterId) {
        return this.getAllOperations(principal).getScoped().getOrDefault(clusterId, new AuthorizedOperations((Set<PermissionsService.ControlCenterOperation>)ImmutableSet.of())).getAuthorizedOperations();
    }

    @Override
    public Set<PermissionsService.ControlCenterOperation> getAllGlobalOperations(JwtPrincipal principal) {
        return this.getAllOperations(principal).getGlobal().getAuthorizedOperations();
    }

    @Override
    public boolean hasClusterAlertsAccess(JwtPrincipal principal, String clusterId) {
        return this.getAllScopedOperations(principal, clusterId).contains((Object)PermissionsService.ControlCenterOperation.CLUSTER_ALERTS);
    }

    @Override
    public Set<String> getAllClusterAlertsAccess(JwtPrincipal principal) {
        return this.getAllOperations(principal).getScoped().entrySet().stream().filter(e -> ((AuthorizedOperations)e.getValue()).getAuthorizedOperations().contains((Object)PermissionsService.ControlCenterOperation.CLUSTER_ALERTS)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public boolean hasReadLicenseAccess(JwtPrincipal principal) {
        return true;
    }

    @Override
    public boolean hasWriteLicenseAccess(JwtPrincipal principal) {
        return this.getAllGlobalOperations(principal).contains((Object)PermissionsService.ControlCenterOperation.WRITE_LICENSE);
    }

    @Override
    public boolean hasBrokerMetricsAccess(JwtPrincipal principal, String clusterId) {
        return this.getAllScopedOperations(principal, clusterId).contains((Object)PermissionsService.ControlCenterOperation.VIEW_BROKER_METRICS);
    }

    @Override
    public boolean isSuperUser(JwtPrincipal principal) {
        return this.getAllGlobalOperations(principal).contains((Object)PermissionsService.ControlCenterOperation.WRITE_LICENSE);
    }

    @Override
    public boolean isVisible(JwtPrincipal principal, Scope scope) {
        return this.getAllVisible(principal, ImmutableMap.of((Object)SINGLE_LOOKUP_KEY, (Object)scope)).contains(SINGLE_LOOKUP_KEY);
    }

    @Override
    public boolean authorize(JwtPrincipal principal, List<Action> actions) {
        return this.authorizeAll(principal, ImmutableMap.of((Object)SINGLE_LOOKUP_KEY, actions)).contains(SINGLE_LOOKUP_KEY);
    }
}

