/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.inject.Provider;
import io.confluent.command.cluster_metadata.CommandClusterMetadata;
import io.confluent.command.record.Command;
import io.confluent.controlcenter.rest.res.KafkaClusterDisplay;
import io.confluent.controlcenter.rest.res.KafkaClusterListResponse;
import java.util.ArrayList;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;

public class ClusterMetadataDaoUtils {
    public static final String KAFKA_CLUSTER_DEFAULT_DISPLAY_ID = "default";
    private static final String KAFKA_CLUSTER_DEFAULT_DISPLAY_NAME = "Unknown";

    public static KafkaClusterDisplay displayCluster(String clusterId, CommandClusterMetadata.ClusterMetadata clusterMetadata) {
        return new KafkaClusterDisplay(ClusterMetadataDaoUtils.getExternalKafkaId(clusterId), ClusterMetadataDaoUtils.getKafkaDisplayName(clusterId, clusterMetadata));
    }

    public static String getKafkaClusterName(CommandClusterMetadata.ClusterMetadata clusterMetadata) {
        if (clusterMetadata != null && !clusterMetadata.getDisplayName().isEmpty()) {
            return clusterMetadata.getDisplayName();
        }
        return "";
    }

    public static String getKafkaDisplayName(String clusterId, String clusterName) {
        if (!clusterName.isEmpty()) {
            return clusterName;
        }
        if (!clusterId.isEmpty()) {
            return clusterId;
        }
        return KAFKA_CLUSTER_DEFAULT_DISPLAY_NAME;
    }

    public static String getKafkaDisplayName(String clusterId, CommandClusterMetadata.ClusterMetadata clusterMetadata) {
        String clusterName = ClusterMetadataDaoUtils.getKafkaClusterName(clusterMetadata);
        return ClusterMetadataDaoUtils.getKafkaDisplayName(clusterId, clusterName);
    }

    public static String getExternalKafkaId(String internalClusterId) {
        if (!internalClusterId.isEmpty()) {
            return internalClusterId;
        }
        return KAFKA_CLUSTER_DEFAULT_DISPLAY_ID;
    }

    public static String getInternalKafkaId(String externalClusterId) {
        if (externalClusterId.equals(KAFKA_CLUSTER_DEFAULT_DISPLAY_ID)) {
            return "";
        }
        return externalClusterId;
    }

    public static KafkaClusterListResponse getKafkaClustersForStreamMonitoring(Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> clusterMetadataStore) {
        ArrayList<KafkaClusterDisplay> clusters = new ArrayList<KafkaClusterDisplay>();
        try (KeyValueIterator iter = ((ReadOnlyKeyValueStore)clusterMetadataStore.get()).all();){
            while (iter.hasNext()) {
                KeyValue entry = (KeyValue)iter.next();
                CommandClusterMetadata.ClusterMetadata clusterMetadata = ((Command.CommandMessage)entry.value).getClusterMetadata();
                if (clusterMetadata.hasConnect()) continue;
                String clusterId = ((Command.CommandKey)entry.key).getGuid();
                clusters.add(ClusterMetadataDaoUtils.displayCluster(clusterId, clusterMetadata));
            }
        }
        String defaultSelectedClusterId = null;
        if (clusters.size() > 0) {
            defaultSelectedClusterId = ((KafkaClusterDisplay)clusters.get((int)0)).clusterId;
        }
        return new KafkaClusterListResponse(defaultSelectedClusterId, clusters);
    }
}

