/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ClusterRegistryConfig;
import io.confluent.controlcenter.data.ClusterMetadataInitializer;
import io.confluent.controlcenter.data.DynamicClusterMetadataInitializer;
import io.confluent.controlcenter.data.StaticClusterMetadataInitializer;

@Singleton
public class ClusterMetadataInitializerProxy
implements ClusterMetadataInitializer {
    public final StaticClusterMetadataInitializer staticClusterMetadataInitializer;
    public final DynamicClusterMetadataInitializer dynamicClusterMetadataInitializer;
    public final ClusterRegistryConfig config;

    @Inject
    public ClusterMetadataInitializerProxy(StaticClusterMetadataInitializer staticClusterMetadataInitializer, DynamicClusterMetadataInitializer dynamicClusterMetadataInitializer, ClusterRegistryConfig config) {
        this.staticClusterMetadataInitializer = staticClusterMetadataInitializer;
        this.dynamicClusterMetadataInitializer = dynamicClusterMetadataInitializer;
        this.config = config;
    }

    @Override
    public ListenableFuture<Void> call() throws Exception {
        this.staticClusterMetadataInitializer.call();
        if (this.config.isClusterRegistryEnabled()) {
            this.dynamicClusterMetadataInitializer.call();
        }
        return null;
    }

    @Override
    public String getBootstrapClusterId() {
        return this.staticClusterMetadataInitializer.getBootstrapClusterId();
    }
}

