/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterModule;
import io.confluent.controlcenter.data.ClusterMetadataDao;
import io.confluent.controlcenter.data.ConsumerOffsetsDao;
import io.confluent.controlcenter.data.ConsumerOffsetsModule;
import io.confluent.controlcenter.healthcheck.HealthCheckModule;
import io.confluent.controlcenter.kafka.AdminSupplier;
import io.confluent.controlcenter.rest.res.ConsumerGroupOffsets;
import io.confluent.controlcenter.rest.res.KafkaClusterDisplay;
import io.confluent.controlcenter.telemetry.TelemetryModule;
import java.util.Map;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.metrics.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerOffsetsFetcher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ConsumerOffsetsFetcher.class);
    private final ClusterMetadataDao clusterMetadataDao;
    private final AdminSupplier<String> adminClientSupplier;
    private final Map<String, Map<String, ConsumerGroupOffsets>> offsets;
    private final int consumerMetadataTimeout;
    private String streamsAppId;
    private String bootstrapClusterId;
    private volatile long totalLag;

    @Inject
    public ConsumerOffsetsFetcher(ClusterMetadataDao clusterMetadataDao, AdminSupplier<String> adminClientSupplier, @ConsumerOffsetsModule.ConsumerOffsets Map<String, Map<String, ConsumerGroupOffsets>> offsets, @ConsumerOffsetsModule.ConsumerMetadataTimeout int consumerMetadataTimeout, @TelemetryModule.C3Metrics Metrics metrics, @ControlCenterModule.StreamsAppId String streamsAppId, @HealthCheckModule.BootstrapClusterId String bootstrapClusterId) {
        this.clusterMetadataDao = clusterMetadataDao;
        this.adminClientSupplier = adminClientSupplier;
        this.offsets = offsets;
        this.consumerMetadataTimeout = consumerMetadataTimeout;
        this.streamsAppId = streamsAppId;
        this.bootstrapClusterId = bootstrapClusterId;
        metrics.addMetric(metrics.metricName("total-lag", "consumer-group", (Map)ImmutableMap.of((Object)"groupId", (Object)streamsAppId)), (config, now) -> this.totalLag);
    }

    @Override
    public void run() {
        try {
            if (!this.clusterMetadataDao.ready()) {
                log.debug("Waiting for ClusterMetadataDao to be ready");
                return;
            }
            for (KafkaClusterDisplay kafkaCluster : this.clusterMetadataDao.getKafkaClustersForManagement().clusters) {
                String clusterId = kafkaCluster.clusterId;
                try {
                    Admin adminClient = this.adminClientSupplier.getClient(clusterId);
                    Throwable throwable = null;
                    try {
                        ConsumerOffsetsDao cgDao = new ConsumerOffsetsDao(clusterId, adminClient, this.consumerMetadataTimeout);
                        Map<String, ConsumerGroupOffsets> cgOffsets = cgDao.getAllConsumerGroupOffsets();
                        this.offsets.put(clusterId, cgOffsets);
                        if (!clusterId.equals(this.bootstrapClusterId)) continue;
                        this.totalLag = cgOffsets.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(this.streamsAppId)).mapToLong(entry -> ((ConsumerGroupOffsets)entry.getValue()).getTotalLag()).sum();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (adminClient == null) continue;
                        if (throwable != null) {
                            try {
                                adminClient.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        adminClient.close();
                    }
                }
                catch (Throwable t) {
                    log.warn(String.format("Unable to fetch consumer offsets for cluster id %s ", clusterId), t);
                }
            }
        }
        catch (Throwable t) {
            log.warn("unable to fetch consumer offsets", t);
        }
    }
}

