/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.confluent.command.record.Command;
import io.confluent.controlcenter.client.ClusterRegistryClient;
import io.confluent.controlcenter.command.CommandModule;
import io.confluent.controlcenter.data.ClusterMetadataDao;
import io.confluent.controlcenter.data.ClusterMetadataDaoUtils;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.controlcenter.rest.res.KafkaCluster;
import io.confluent.controlcenter.rest.res.KafkaClusterDisplay;
import io.confluent.controlcenter.rest.res.KafkaClusterListResponse;
import io.confluent.rbacapi.entities.ClusterInfo;
import io.confluent.rbacapi.entities.HostInfo;
import io.confluent.rbacapi.utils.ClusterType;
import io.confluent.security.authorizer.Scope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;

public class DynamicClusterMetadataDao
implements ClusterMetadataDao {
    private static final String KAFKA_CLUSTER_MAP_ID = "kafka-cluster";
    private final ClusterRegistryClient registryClient;
    private final Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> clusterMetadataStore;

    @Inject
    public DynamicClusterMetadataDao(ClusterRegistryClient registryClient, @CommandModule.ClusterMetadataStore Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> clusterMetadataStore) {
        this.registryClient = registryClient;
        this.clusterMetadataStore = clusterMetadataStore;
    }

    @Override
    public List<KafkaCluster> getKafkaClusters(TokenCredential cred) {
        Preconditions.checkNotNull((Object)cred, (Object)"TokenCredential cannot be null");
        Preconditions.checkNotNull((Object)cred.token, (Object)"TokenCredential token cannot be null");
        return this.processRawClusters(this.registryClient.getClusters(ClusterType.KAFKA_CLUSTER, cred.token));
    }

    @Override
    public List<KafkaCluster> getKafkaClusters() {
        return this.processRawClusters(this.registryClient.getClusters(ClusterType.KAFKA_CLUSTER));
    }

    private List<KafkaCluster> processRawClusters(List<ClusterInfo> rawClusters) {
        Map<String, KafkaCluster> registeredClusters = rawClusters.stream().collect(Collectors.toMap(cluster -> this.getKafkaClusterId(cluster.getScope()), this::convertClusterInfoToKafkaCluster));
        KafkaClusterListResponse kafkaClustersForStreamMonitoring = ClusterMetadataDaoUtils.getKafkaClustersForStreamMonitoring(this.clusterMetadataStore);
        Map<String, KafkaCluster> monitoredClusters = kafkaClustersForStreamMonitoring.clusters.stream().collect(Collectors.toMap(cluster -> cluster.clusterId, this::convertClusterInfoToKafkaCluster));
        monitoredClusters.forEach((key, value) -> registeredClusters.merge((String)key, (KafkaCluster)value, (v1, v2) -> v1));
        return new ArrayList<KafkaCluster>(registeredClusters.values());
    }

    @Override
    public KafkaClusterListResponse getKafkaClustersForStreamMonitoring() {
        return ClusterMetadataDaoUtils.getKafkaClustersForStreamMonitoring(this.clusterMetadataStore);
    }

    @Override
    public KafkaClusterListResponse getKafkaClustersForManagement() {
        List<ClusterInfo> rawClusters = this.registryClient.getClusters(ClusterType.KAFKA_CLUSTER);
        return this.getKafkaClusterListResponse(rawClusters);
    }

    private String getKafkaClusterId(Scope scope) {
        return scope.clusters().getOrDefault(KAFKA_CLUSTER_MAP_ID, "default");
    }

    List<String> getBootstrapServer(List<HostInfo> hosts) {
        return hosts.stream().map(h -> new String(h.getHost() + ":" + h.getPort())).collect(Collectors.toList());
    }

    private KafkaClusterListResponse getKafkaClusterListResponse(List<ClusterInfo> rawClusters) {
        List<KafkaClusterDisplay> clusters = rawClusters.stream().map(cluster -> new KafkaClusterDisplay(this.getKafkaClusterId(cluster.getScope()), cluster.getClusterName())).collect(Collectors.toList());
        String defaultSelectedClusterId = null;
        if (clusters.size() > 0) {
            defaultSelectedClusterId = ((KafkaClusterDisplay)clusters.get((int)0)).clusterId;
        }
        return new KafkaClusterListResponse(defaultSelectedClusterId, clusters);
    }

    private ClusterInfo convertKafkaClusterToClusterInfo(ClusterInfo clusterInfo, KafkaCluster cluster) {
        return new ClusterInfo(cluster.displayName, Scope.kafkaClusterScope((String)((String)ObjectUtils.firstNonNull((Object[])new String[]{cluster.clusterId, this.getKafkaClusterId(clusterInfo.getScope())}))), this.getHostList((List)ObjectUtils.firstNonNull((Object[])new List[]{cluster.bootstrapServers, this.getBootstrapServer(clusterInfo.getHosts())})), clusterInfo.getProtocol());
    }

    private KafkaCluster convertClusterInfoToKafkaCluster(ClusterInfo cluster) {
        return new KafkaCluster(this.getKafkaClusterId(cluster.getScope()), cluster.getClusterName(), Collections.emptyList(), this.getBootstrapServer(cluster.getHosts()));
    }

    private KafkaCluster convertClusterInfoToKafkaCluster(KafkaClusterDisplay cluster) {
        return new KafkaCluster(cluster.clusterId, cluster.displayName, Collections.emptyList(), Collections.emptyList());
    }

    private List<HostInfo> getHostList(List<String> bootstrapServers) {
        return bootstrapServers.stream().map(h -> {
            String[] host = h.split(":");
            return new HostInfo(host[0], Integer.parseInt(host[1]));
        }).collect(Collectors.toList());
    }

    @Override
    public void externalUpdateKafkaCluster(String externalClusterId, KafkaCluster cluster, long timeoutMs, TokenCredential cred) throws Exception {
        ClusterInfo oldClusterInfo = this.registryClient.getKafkaClusterByID(externalClusterId, cred.token);
        ClusterInfo clusterInfo = this.convertKafkaClusterToClusterInfo(oldClusterInfo, cluster);
        this.registryClient.updateCluster(oldClusterInfo, clusterInfo, cred.token);
    }

    @Override
    public void externalUpdateKafkaCluster(String externalClusterId, KafkaCluster cluster, long timeoutMs) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean ready() {
        return this.registryClient.ready();
    }
}

