/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.collect.ImmutableSet;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.controlcenter.data.AbstractPermissionsService;
import io.confluent.controlcenter.data.ClusterMetadataDao;
import io.confluent.controlcenter.data.PermissionsService;
import io.confluent.controlcenter.rest.res.AllPermissionsResponse;
import io.confluent.controlcenter.rest.res.KafkaCluster;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Scope;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NoopPermissionsService
extends AbstractPermissionsService {
    private static final Set<PermissionsService.ControlCenterOperation> ALL_SCOPED_OPERATIONS = ImmutableSet.of((Object)((Object)PermissionsService.ControlCenterOperation.VIEW_BROKER_METRICS), (Object)((Object)PermissionsService.ControlCenterOperation.CLUSTER_ALERTS), (Object)((Object)PermissionsService.ControlCenterOperation.VIEW_CLUSTER_SETTINGS));
    private static final Set<PermissionsService.ControlCenterOperation> ALL_GLOBAL_OPERATIONS = ImmutableSet.of((Object)((Object)PermissionsService.ControlCenterOperation.WRITE_LICENSE));
    private final ClusterMetadataDao clusterMetadataDao;

    public NoopPermissionsService(ClusterMetadataDao clusterMetadata) {
        this.clusterMetadataDao = clusterMetadata;
    }

    @Override
    public AllPermissionsResponse getAllOperations(JwtPrincipal principal) {
        HashMap<String, Set<PermissionsService.ControlCenterOperation>> clusterScopedOperations = new HashMap<String, Set<PermissionsService.ControlCenterOperation>>();
        for (KafkaCluster kafkaCluster : this.clusterMetadataDao.getKafkaClusters()) {
            clusterScopedOperations.put(kafkaCluster.clusterId, ALL_SCOPED_OPERATIONS);
        }
        return new AllPermissionsResponse(clusterScopedOperations, ALL_GLOBAL_OPERATIONS);
    }

    @Override
    public <T> Set<T> getAllVisible(JwtPrincipal principal, Map<T, Scope> scopeMap) {
        return scopeMap.keySet();
    }

    @Override
    public <T> Set<T> authorizeAll(JwtPrincipal principal, Map<T, List<Action>> authorizeMap) {
        return authorizeMap.keySet();
    }
}

