/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.Futures;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.confluent.command.cluster_metadata.CommandClusterMetadata;
import io.confluent.command.kafka.CommandStore;
import io.confluent.command.record.Command;
import io.confluent.controlcenter.command.CommandModule;
import io.confluent.controlcenter.data.ClusterMetadataDao;
import io.confluent.controlcenter.data.ClusterMetadataDaoUtils;
import io.confluent.controlcenter.kafka.ClusterChangeEvent;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.controlcenter.rest.res.KafkaCluster;
import io.confluent.controlcenter.rest.res.KafkaClusterDisplay;
import io.confluent.controlcenter.rest.res.KafkaClusterListResponse;
import io.confluent.controlcenter.util.ConfigUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;

public class StaticClusterMetadataDao
implements ClusterMetadataDao {
    private final Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> clusterMetadataStore;
    private final CommandStore commandStore;

    @Inject
    public StaticClusterMetadataDao(@CommandModule.ClusterMetadataStore Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> clusterMetadataStore, CommandStore commandStore) {
        this.clusterMetadataStore = clusterMetadataStore;
        this.commandStore = commandStore;
    }

    @Override
    public List<KafkaCluster> getKafkaClusters() {
        List<KafkaCluster> rawClusters = this.getAllKafkaClusters();
        ArrayList<KafkaCluster> displayClusters = new ArrayList<KafkaCluster>();
        for (KafkaCluster cluster : rawClusters) {
            displayClusters.add(new KafkaCluster(ClusterMetadataDaoUtils.getExternalKafkaId(cluster.clusterId), ClusterMetadataDaoUtils.getKafkaDisplayName(cluster.clusterId, cluster.displayName), cluster.zookeeperConnect, cluster.bootstrapServers));
        }
        return displayClusters;
    }

    @Override
    public List<KafkaCluster> getKafkaClusters(TokenCredential cred) {
        return this.getKafkaClusters();
    }

    private List<KafkaCluster> getAllKafkaClusters() {
        ArrayList<KafkaCluster> clusters = new ArrayList<KafkaCluster>();
        try (KeyValueIterator iter = ((ReadOnlyKeyValueStore)this.clusterMetadataStore.get()).all();){
            while (iter.hasNext()) {
                KeyValue entry = (KeyValue)iter.next();
                CommandClusterMetadata.ClusterMetadata clusterMetadata = ((Command.CommandMessage)entry.value).getClusterMetadata();
                if (!clusterMetadata.hasKafka()) continue;
                String clusterId = ((Command.CommandKey)entry.key).getGuid();
                clusters.add(this.kafkaCluster(clusterMetadata, clusterId));
            }
        }
        return clusters;
    }

    private KafkaCluster kafkaCluster(CommandClusterMetadata.ClusterMetadata clusterMetadata, String clusterId) {
        return new KafkaCluster(clusterId, StaticClusterMetadataDao.getKafkaClusterName(clusterMetadata), (List<String>)clusterMetadata.getKafka().getZookeeperConnectList(), (List<String>)clusterMetadata.getKafka().getBootstrapServersList());
    }

    @Override
    public KafkaClusterListResponse getKafkaClustersForStreamMonitoring() {
        return ClusterMetadataDaoUtils.getKafkaClustersForStreamMonitoring(this.clusterMetadataStore);
    }

    @Override
    public KafkaClusterListResponse getKafkaClustersForManagement() {
        ArrayList<KafkaClusterDisplay> clusters = new ArrayList<KafkaClusterDisplay>();
        try (KeyValueIterator iter = ((ReadOnlyKeyValueStore)this.clusterMetadataStore.get()).all();){
            while (iter.hasNext()) {
                KeyValue entry = (KeyValue)iter.next();
                CommandClusterMetadata.ClusterMetadata clusterMetadata = ((Command.CommandMessage)entry.value).getClusterMetadata();
                String clusterId = ((Command.CommandKey)entry.key).getGuid();
                if (!clusterMetadata.hasKafka() || clusterMetadata.getKafka().getBootstrapServersCount() == 0 || clusterId.isEmpty()) continue;
                clusters.add(ClusterMetadataDaoUtils.displayCluster(clusterId, clusterMetadata));
            }
        }
        String defaultSelectedClusterId = null;
        if (clusters.size() > 0) {
            defaultSelectedClusterId = ((KafkaClusterDisplay)clusters.get((int)0)).clusterId;
        }
        return new KafkaClusterListResponse(defaultSelectedClusterId, clusters);
    }

    static Command.CommandKey keyForCluster(String clusterId) {
        return Command.CommandKey.newBuilder().setConfigType(Command.CommandConfigType.CLUSTER_METADATA).setGuid(clusterId).build();
    }

    private static String getKafkaClusterName(CommandClusterMetadata.ClusterMetadata clusterMetadata) {
        if (clusterMetadata != null && !clusterMetadata.getDisplayName().isEmpty()) {
            return clusterMetadata.getDisplayName();
        }
        return "";
    }

    @Override
    public void externalUpdateKafkaCluster(String externalClusterId, KafkaCluster cluster, long timeoutMs) throws Exception {
        String clusterId = ClusterMetadataDaoUtils.getInternalKafkaId(externalClusterId);
        this.updateKafkaCluster(cluster, timeoutMs, clusterId);
    }

    @Override
    public void externalUpdateKafkaCluster(String externalClusterId, KafkaCluster cluster, long timeoutMs, TokenCredential cred) throws Exception {
        this.externalUpdateKafkaCluster(externalClusterId, cluster, timeoutMs);
    }

    public void updateKafkaCluster(KafkaCluster cluster, long timeoutMs, String clusterId) throws InterruptedException, TimeoutException, ExecutionException {
        Command.CommandKey key = StaticClusterMetadataDao.keyForCluster(clusterId);
        Command.CommandMessage.Builder msgBuilder = this.getCmdMsgBuilder(key);
        this.updateClusterFields(msgBuilder, cluster);
        this.commandStore.update(key, msgBuilder.build(), timeoutMs);
    }

    public Future<KafkaCluster> asyncUpdateKafkaClusterPreservingName(final String clusterId, KafkaCluster cluster) {
        Command.CommandKey key = StaticClusterMetadataDao.keyForCluster(clusterId);
        Command.CommandMessage.Builder msgBuilder = this.getCmdMsgBuilder(key);
        this.updateClusterFieldsPreservingName(msgBuilder, cluster);
        final Command.CommandMessage value = msgBuilder.build();
        Future res = this.commandStore.updateAsync(key, value);
        return Futures.lazyTransform((Future)res, (Function)new Function<RecordMetadata, KafkaCluster>(){

            public KafkaCluster apply(RecordMetadata input) {
                return StaticClusterMetadataDao.this.kafkaCluster(value.getClusterMetadata(), clusterId);
            }
        });
    }

    private Command.CommandMessage.Builder getCmdMsgBuilder(Command.CommandKey key) {
        Command.CommandMessage msg = (Command.CommandMessage)((ReadOnlyKeyValueStore)this.clusterMetadataStore.get()).get((Object)key);
        if (msg != null) {
            return Command.CommandMessage.newBuilder((Command.CommandMessage)msg);
        }
        return Command.CommandMessage.newBuilder();
    }

    @VisibleForTesting
    void updateClusterFields(Command.CommandMessage.Builder msgBuilder, KafkaCluster cluster) {
        CommandClusterMetadata.ClusterMetadata.Builder clusterMetadataBuilder = msgBuilder.getClusterMetadataBuilder();
        CommandClusterMetadata.KafkaClusterMetadata.Builder kafkaBuilder = clusterMetadataBuilder.getKafkaBuilder();
        if (cluster.displayName != null) {
            clusterMetadataBuilder.setDisplayName(cluster.displayName);
        }
        this.updateConnectionStrings(cluster, kafkaBuilder);
    }

    @VisibleForTesting
    void updateClusterFieldsPreservingName(Command.CommandMessage.Builder msgBuilder, KafkaCluster cluster) {
        CommandClusterMetadata.ClusterMetadata.Builder clusterMetadataBuilder = msgBuilder.getClusterMetadataBuilder();
        CommandClusterMetadata.KafkaClusterMetadata.Builder kafkaBuilder = clusterMetadataBuilder.getKafkaBuilder();
        if (cluster.displayName != null && clusterMetadataBuilder.getDisplayName().isEmpty()) {
            clusterMetadataBuilder.setDisplayName(cluster.displayName);
        }
        this.updateConnectionStrings(cluster, kafkaBuilder);
    }

    private void updateConnectionStrings(KafkaCluster cluster, CommandClusterMetadata.KafkaClusterMetadata.Builder kafkaBuilder) {
        if (cluster.zookeeperConnect != null) {
            kafkaBuilder.clearZookeeperConnect();
            kafkaBuilder.addAllZookeeperConnect(cluster.zookeeperConnect);
        }
        if (cluster.bootstrapServers != null) {
            kafkaBuilder.clearBootstrapServers();
            kafkaBuilder.addAllBootstrapServers(cluster.bootstrapServers);
        }
    }

    @Subscribe
    public void handleClusterChangeEvent(ClusterChangeEvent clusterChangeEvent) {
        this.asyncUpdateKafkaClusterPreservingName(clusterChangeEvent.getClusterId(), new KafkaCluster(clusterChangeEvent.getClusterId(), clusterChangeEvent.getClusterName(), Collections.emptyList(), ConfigUtils.getList(clusterChangeEvent.getConfig(), "bootstrap.servers")));
    }
}

