/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.data;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.BootstrapClientConfigSupplier;
import io.confluent.controlcenter.StaticClusterConfigSupplier;
import io.confluent.controlcenter.command.CommandMigrator;
import io.confluent.controlcenter.data.ClusterMetadataInitializer;
import io.confluent.controlcenter.data.StaticClusterMetadataInitializerDelegate;
import io.confluent.controlcenter.kafka.StaticClusterManager;
import io.confluent.controlcenter.rest.ControlCenterRestModule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StaticClusterMetadataInitializer
implements ClusterMetadataInitializer {
    private static final Logger log = LoggerFactory.getLogger(StaticClusterMetadataInitializer.class);
    static final String DEFAULT_CLUSTER_KEY = "controlcenter.cluster";
    private final StaticClusterMetadataInitializerDelegate delegate;
    private final BootstrapClientConfigSupplier bootstrapClientConfigSupplier;
    private final StaticClusterConfigSupplier kafkaClusterConfigSupplier;
    private final StaticClusterManager clusterManager;
    private String bootstrapClusterId;
    private final CommandMigrator commandMigrator;

    @Inject
    public StaticClusterMetadataInitializer(StaticClusterMetadataInitializerDelegate delegate, BootstrapClientConfigSupplier bootstrapClientConfigSupplier, @ControlCenterRestModule.KafkaClusterConfigSupplier StaticClusterConfigSupplier kafkaClusterConfigSupplier, StaticClusterManager clusterManager, CommandMigrator commandMigrator) {
        this.delegate = delegate;
        this.bootstrapClientConfigSupplier = bootstrapClientConfigSupplier;
        this.kafkaClusterConfigSupplier = kafkaClusterConfigSupplier;
        this.clusterManager = clusterManager;
        this.commandMigrator = commandMigrator;
    }

    @Override
    public ListenableFuture<Void> call() throws Exception {
        this.bootstrapClusterId = (String)this.clusterManager.register(DEFAULT_CLUSTER_KEY, (Map<String, Object>)this.bootstrapClientConfigSupplier.get()).get();
        ArrayList<Object> registrations = new ArrayList<Object>();
        registrations.add(Futures.immediateFuture((Object)this.bootstrapClusterId));
        for (Map.Entry<String, Map<String, Object>> entry : this.kafkaClusterConfigSupplier.getConfigurations().entrySet()) {
            registrations.add(this.clusterManager.register(entry.getKey(), entry.getValue()));
        }
        Futures.addCallback((ListenableFuture)Futures.allAsList(registrations), (FutureCallback)new FutureCallback<List<String>>(){

            public void onSuccess(@Nullable List<String> clusterIds) {
                if (clusterIds != null && StaticClusterMetadataInitializer.this.delegate.canPurgeStaleEntries()) {
                    StaticClusterMetadataInitializer.this.commandMigrator.purgeStaleEntries(new HashSet<String>(clusterIds));
                }
            }

            public void onFailure(Throwable throwable) {
                log.error("Not all clusters registered successfully", throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return null;
    }

    @Override
    public String getBootstrapClusterId() {
        return this.bootstrapClusterId;
    }
}

