/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.healthcheck;

import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.segment.analytics.Analytics;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.annotation.Mode;
import io.confluent.controlcenter.healthcheck.AllHealthCheck;
import io.confluent.controlcenter.healthcheck.HealthCheck;
import io.confluent.controlcenter.healthcheck.ManagementHealthCheck;
import io.confluent.controlcenter.record.Controlcenter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckModule.class);

    protected void configure() {
    }

    @Provides
    @Singleton
    @Inject
    public HealthCheck provideHealthCheck(Injector injector, Mode.ModeType modeType) {
        if (modeType == Mode.ModeType.ALL) {
            return (HealthCheck)injector.getInstance(AllHealthCheck.class);
        }
        return (HealthCheck)injector.getInstance(ManagementHealthCheck.class);
    }

    @Provides
    @ClusterStatus
    @Inject
    @Singleton
    protected Map<String, Map<CommandAlert.BrokerTriggerMetricType, Controlcenter.TriggerMeasurement>> provideClusterStatus() {
        return new ConcurrentHashMap<String, Map<CommandAlert.BrokerTriggerMetricType, Controlcenter.TriggerMeasurement>>();
    }

    @Provides
    @Inject
    @Singleton
    public Analytics getAnalytics(@SegmentId String segmentId, @SegmentEndpoint String endpoint) {
        return Analytics.builder((String)segmentId).endpoint(endpoint).build();
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface SegmentEndpoint {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface SegmentId {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface PhoneHomeCustomerId {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface BootstrapClusterId {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ControlCenterInstance {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface SessionId {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface ClusterStatus {
    }
}

