/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.confluent.controlcenter.BootstrapClientConfigSupplier;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.client.ClusterRegistryClient;
import io.confluent.controlcenter.healthcheck.HealthCheckModule;
import io.confluent.controlcenter.kafka.ClusterChangeEvent;
import io.confluent.controlcenter.kafka.ClusterManagementModule;
import io.confluent.controlcenter.kafka.ClusterManager;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.controlcenter.util.RetryUtils;
import io.confluent.rbacapi.entities.ClusterInfo;
import io.confluent.rbacapi.utils.ClusterType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DynamicClusterManager
implements ClusterManager {
    private static final Logger log = LoggerFactory.getLogger(DynamicClusterManager.class);
    static final String DEFAULT_CLUSTER_KEY = "controlcenter.cluster";
    private static final int RETRY_BACKOFF = 5000;
    private final ClusterRegistryClient clusterRegistryClient;
    private final BootstrapClientConfigSupplier bootstrapClientConfigSupplier;
    private final Provider<EventBus> eventBusProvider;
    private final ControlCenterRbacConfig rbacConfig;
    private final String bootstrapClusterId;
    private final Set<String> seenClustersIds = new HashSet<String>();

    @Inject
    public DynamicClusterManager(@ClusterManagementModule.ClusterChangeEventBus Provider<EventBus> eventBusProvider, @HealthCheckModule.BootstrapClusterId String bootstrapClusterId, BootstrapClientConfigSupplier bootstrapClientConfigSupplier, ClusterRegistryClient clusterRegistryClient, ControlCenterRbacConfig rbacConfig) {
        this.eventBusProvider = eventBusProvider;
        this.rbacConfig = rbacConfig;
        this.bootstrapClusterId = bootstrapClusterId;
        this.bootstrapClientConfigSupplier = bootstrapClientConfigSupplier;
        this.clusterRegistryClient = clusterRegistryClient;
    }

    @Override
    public Map<String, Object> getConfiguration(TokenCredential credential) {
        Map<String, Map<String, Object>> configurations = this.getConfigurations();
        Map clusterConfigs = (Map)Preconditions.checkNotNull(configurations.get(credential.cluster), (String)"Unknown configuration for cluster id %s", (Object)credential.cluster);
        return this.rbacConfig.injectRbacConfigs(clusterConfigs, credential.token);
    }

    @Override
    public Map<String, Map<String, Object>> getConfigurations() {
        HashMap<String, Map<String, Object>> configurations = new HashMap<String, Map<String, Object>>();
        if (this.clusterRegistryClient.ready()) {
            List<ClusterInfo> clusterInfos = this.clusterRegistryClient.getClusters(ClusterType.KAFKA_CLUSTER);
            for (ClusterInfo clusterInfo : clusterInfos) {
                configurations.put(DynamicClusterManager.extractClusterId(clusterInfo), DynamicClusterManager.extractConfiguration(clusterInfo));
            }
        }
        configurations.put(this.bootstrapClusterId, (Map<String, Object>)this.bootstrapClientConfigSupplier.get());
        return configurations;
    }

    public ListenableFuture<Void> initialize() {
        return RetryUtils.retryWithJitter(() -> {
            SettableFuture lookup = SettableFuture.create();
            EventBus clusterChangeEventBus = (EventBus)this.eventBusProvider.get();
            if (this.clusterRegistryClient.ready()) {
                List<ClusterInfo> clusterInfos = this.clusterRegistryClient.getClusters(ClusterType.KAFKA_CLUSTER);
                this.maybePostEvent(DEFAULT_CLUSTER_KEY, this.bootstrapClusterId, (Map<String, Object>)this.bootstrapClientConfigSupplier.get(), clusterChangeEventBus);
                clusterInfos.forEach(clusterInfo -> this.maybePostEvent(clusterInfo.getClusterName(), DynamicClusterManager.extractClusterId(clusterInfo), DynamicClusterManager.extractConfiguration(clusterInfo), clusterChangeEventBus));
                lookup.set(null);
            } else {
                log.info("Failed to fetch configuration");
                lookup.setException((Throwable)new Exception("Failed to fetch configuration"));
            }
            return lookup;
        }, 5000);
    }

    void maybePostEvent(String clusterName, String clusterId, Map<String, Object> config, EventBus clusterChangeEventBus) {
        if (!this.seenClustersIds.contains(clusterId)) {
            clusterChangeEventBus.post((Object)new ClusterChangeEvent(clusterName, clusterId, config, clusterChangeEventBus));
            this.seenClustersIds.add(clusterId);
        }
    }

    @VisibleForTesting
    static Map<String, Object> extractConfiguration(ClusterInfo clusterInfo) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", DynamicClusterManager.getBootstrapServers(clusterInfo));
        config.put("security.protocol", clusterInfo.getProtocol().value());
        return Collections.unmodifiableMap(config);
    }

    private static String getBootstrapServers(ClusterInfo clusterInfo) {
        StringBuilder builder = new StringBuilder();
        clusterInfo.getHosts().forEach(hostInfo -> builder.append(String.format("%s:%d,", hostInfo.getHost(), hostInfo.getPort())));
        return builder.toString();
    }

    private static String extractClusterId(ClusterInfo clusterInfo) {
        return (String)clusterInfo.getScope().clusters().get(ClusterType.KAFKA_CLUSTER.toString());
    }
}

