/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.kafka;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.kafka.AdminClientFactory;
import io.confluent.controlcenter.kafka.AdminSupplier;
import io.confluent.controlcenter.kafka.ClusterManager;
import io.confluent.controlcenter.rest.TokenCredential;
import java.util.Map;
import org.apache.kafka.clients.admin.AdminClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KafkaClusterAdminSupplier
implements AdminSupplier<TokenCredential> {
    private static final Logger log = LoggerFactory.getLogger(KafkaClusterAdminSupplier.class);
    private final AdminClientFactory clientFactory;
    private final ClusterManager clusterManager;

    @Inject
    public KafkaClusterAdminSupplier(AdminClientFactory clientFactory, ClusterManager clusterManager) {
        this.clientFactory = clientFactory;
        this.clusterManager = clusterManager;
    }

    public AdminClient getClient(TokenCredential credential) {
        return this.clientFactory.createClient(this.getConfigs(credential));
    }

    private Map<String, Object> getConfigs(TokenCredential credential) {
        return (Map)Preconditions.checkNotNull(this.clusterManager.getConfiguration(credential), (String)"Unknown configuration for cluster id %s", (Object)credential.cluster);
    }
}

