/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.kafka;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.kafka.ClusterChangeEvent;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheckModule;
import io.confluent.controlcenter.servicehealthcheck.SingleServiceHealthCheck;
import io.confluent.controlcenter.util.ConfigUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KafkaRestManager {
    private static final Logger log = LoggerFactory.getLogger(KafkaRestManager.class);
    private final Function<List<String>, SingleServiceHealthCheck> serviceHealthCheckSupplier;
    private final Map<String, SingleServiceHealthCheck> healthCheckMap = new ConcurrentHashMap<String, SingleServiceHealthCheck>();

    @Inject
    public KafkaRestManager(@ServiceHealthCheckModule.KafkaRestServiceHealthCheck Function<List<String>, SingleServiceHealthCheck> serviceHealthCheckSupplier) {
        this.serviceHealthCheckSupplier = serviceHealthCheckSupplier;
    }

    public List<String> getEndpoints(String clusterId) {
        SingleServiceHealthCheck healthCheck = this.healthCheckMap.get(clusterId);
        if (healthCheck == null) {
            return null;
        }
        return healthCheck.getHealthyUrls();
    }

    public void markEndpointUnhealthy(String clusterId, String url) {
        SingleServiceHealthCheck healthCheck = this.healthCheckMap.get(clusterId);
        if (healthCheck != null) {
            healthCheck.markUnhealthy(url);
        }
    }

    public SingleServiceHealthCheck getHealthCheck(String clusterId) {
        return this.healthCheckMap.get(clusterId);
    }

    public void registerCluster(String clusterId, Map<String, Object> config) {
        this.putCluster(clusterId, config);
    }

    @Subscribe
    public void registerCluster(ClusterChangeEvent clusterChangeEvent) {
        this.putCluster(clusterChangeEvent.getClusterId(), clusterChangeEvent.getConfig());
    }

    private void putCluster(String clusterId, Map<String, Object> config) {
        Preconditions.checkNotNull((Object)clusterId);
        List<String> urls = ConfigUtils.getList(config, "cprest.url");
        if (urls != null) {
            this.healthCheckMap.put(clusterId, this.serviceHealthCheckSupplier.apply(urls));
        }
    }
}

