/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.kafka;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.confluent.controlcenter.kafka.ClusterManager;
import io.confluent.controlcenter.kafka.ProducerSupplier;
import io.confluent.controlcenter.rest.TokenCredential;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerConfig;

public class ProducerManager<K, V>
implements ProducerSupplier<K, V> {
    private final ClusterManager clusterManager;
    private final Map<String, Object> additionalProducerConfigs;

    @Inject
    public ProducerManager(ClusterManager clusterManager, Map<String, Object> additionalProducerConfigs) {
        this.clusterManager = clusterManager;
        this.additionalProducerConfigs = additionalProducerConfigs;
    }

    @Override
    public KafkaProducer<K, V> getProducer(TokenCredential cred) {
        HashMap configs = Maps.newHashMap(this.clusterManager.getConfiguration(cred));
        configs.putAll(this.additionalProducerConfigs);
        ProducerConfig producerConfig = new ProducerConfig((Map)configs);
        return new KafkaProducer(producerConfig.originals());
    }
}

