/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.ksql;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ClusterMetadata;
import io.confluent.controlcenter.StaticClusterConfigSupplier;
import io.confluent.controlcenter.httpclient.HttpCredential;
import io.confluent.controlcenter.rest.ControlCenterRestModule;
import io.confluent.controlcenter.rest.res.KsqlCluster;
import io.confluent.controlcenter.util.ConfigUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class KsqlClusterMetadata
extends ClusterMetadata<KsqlCluster> {
    private static final Logger log = LoggerFactory.getLogger(KsqlClusterMetadata.class);

    @Inject
    public KsqlClusterMetadata(@ControlCenterRestModule.KsqlClusterConfigSupplier StaticClusterConfigSupplier ksqlClusterConfigSupplier) {
        this.addClusters(ksqlClusterConfigSupplier.getConfigurations());
    }

    @Override
    protected KsqlCluster createCluster(String displayName, Map<String, Object> config) {
        List<String> endpoints = ConfigUtils.getList(config, "url");
        if (this.checkInvalidEndpoints(endpoints)) {
            log.error("No valid endpoint urls specified for ksql '{}'", (Object)displayName);
            return null;
        }
        List<String> advertisedEndpoints = ConfigUtils.getList(config, "advertised.url");
        if (advertisedEndpoints == null) {
            advertisedEndpoints = endpoints;
        }
        HttpCredential credential = this.createCredential(displayName, config);
        return new KsqlCluster(displayName, displayName, endpoints, advertisedEndpoints, credential);
    }

    @Override
    protected void addCluster(KsqlCluster cluster) {
        Preconditions.checkNotNull((Object)cluster);
        this.clusters.add(cluster);
        this.endpointsLookup.put(cluster.getClusterId(), cluster.getEndpoints());
        if (cluster.getCredential() != null) {
            this.credentialsLookup.put(cluster.getClusterId(), cluster.getCredential());
        }
    }
}

