/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.license;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.license.License;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseInfo {
    private static final Logger log = LoggerFactory.getLogger(LicenseInfo.class);
    private static final String TYPE_CLAIM_NAME = "licenseType";
    private License license;

    public LicenseInfo(License license) {
        this.license = license;
    }

    public long getExpiration() {
        try {
            Date expirationDate = this.license.expirationDate();
            return expirationDate != null ? expirationDate.getTime() : Long.MIN_VALUE;
        }
        catch (Throwable t) {
            log.warn("Unable to get license expiration", t);
            return 0L;
        }
    }

    public String getAudience() {
        if (this.license.audience().isEmpty()) {
            return null;
        }
        return (String)this.license.audience().get(0);
    }

    public String getLicenseType() throws MalformedClaimException, InvalidJwtException {
        JwtClaims jwtClaims = JwtClaims.parse((String)this.getPayload());
        return "basics".equalsIgnoreCase(jwtClaims.getStringClaimValue(TYPE_CLAIM_NAME)) ? "BASICS" : this.license.type().toString();
    }

    public String getPayload() {
        String[] licenseArr = this.license.serializedForm().split("\\.");
        if (licenseArr.length < 2) {
            return null;
        }
        Base64 base64Url = new Base64(true);
        try {
            return new String(base64Url.decode(licenseArr[1]), "utf-8");
        }
        catch (Throwable t) {
            log.warn("Could not convert decoded license body to String", t);
            return null;
        }
    }

    public String getString() {
        return this.license.serializedForm();
    }

    @JsonProperty(value="isCP4CC")
    public boolean isCP4CC() {
        return this.license.deploymentScope().equals((Object)License.DeploymentScope.CP_FOR_CC);
    }
}

