/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.license;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.confluent.command.record.Command;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.command.CommandModule;
import io.confluent.controlcenter.kafka.ClusterManager;
import io.confluent.controlcenter.license.LicenseHolder;
import io.confluent.controlcenter.license.LicenseReader;
import io.confluent.controlcenter.license.LicenseSelectionStrategy;
import io.confluent.controlcenter.license.LicenseUtils;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.license.License;
import io.confluent.license.LicenseManager;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.streams.StreamsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseModule
implements Module {
    private static final Logger log = LoggerFactory.getLogger(LicenseModule.class);

    public void configure(Binder binder) {
    }

    @Provides
    @Singleton
    @Inject
    private LicenseHolder provide(ControlCenterConfig controlCenterConfig, @CommandModule.CommandStoreStreamsConfig StreamsConfig streamsConfig, ClusterManager clusterManager, @CommandModule.CommandTopic TopicStoreMaster.Topic<Command.CommandKey, Command.CommandMessage, Void, Void> commandTopic) throws Exception {
        Password licenseStr = controlCenterConfig.getPassword("confluent.license");
        LicenseManager licenseMgr = this.createLicenseManager(controlCenterConfig, streamsConfig, clusterManager, commandTopic);
        List<License> licenses = LicenseReader.readAndRegisterLicenses(licenseStr.value(), licenseMgr);
        return this.createAndStartLicenseHolder(licenses, licenseMgr);
    }

    private LicenseManager createLicenseManager(ControlCenterConfig controlCenterConfig, StreamsConfig streamsConfig, ClusterManager clusterManager, TopicStoreMaster.Topic<Command.CommandKey, Command.CommandMessage, Void, Void> commandTopic) {
        String clientId = TopicStoreMaster.nameJoin(controlCenterConfig.getString("confluent.controlcenter.license.manager"), controlCenterConfig.getString("confluent.controlcenter.id"));
        String topicName = commandTopic.name;
        Map producerConfig = streamsConfig.getProducerConfigs(clientId);
        Map consumerConfig = streamsConfig.getGlobalConsumerConfigs(clientId);
        Map adminConfig = streamsConfig.getAdminConfigs(clientId);
        try {
            adminConfig.put("replication.factor", Short.toString(controlCenterConfig.getShort("confluent.controlcenter.command.topic.replication")));
        }
        catch (Exception e) {
            log.info("Replication factor for command topic hasn't been configured. Using default value.");
        }
        LicenseManager licenseMgr = new LicenseManager(topicName, producerConfig, consumerConfig, adminConfig);
        Map<String, Map<String, Object>> clusters = clusterManager.getConfigurations();
        for (Map.Entry<String, Map<String, Object>> cluster : clusters.entrySet()) {
            String clusterId = cluster.getKey();
            log.info("Adding cluster to license manager : cluster id = " + clusterId);
            licenseMgr.addCluster(clientId, cluster.getValue());
        }
        return licenseMgr;
    }

    private LicenseHolder createAndStartLicenseHolder(List<License> licenses, LicenseManager licenseMgr) {
        log.info("License(s) found: {}", (Object)licenses.size());
        LicenseHolder handleLicenseChange = new LicenseHolder(licenses, licenseMgr);
        licenseMgr.addListener((Consumer)handleLicenseChange);
        licenseMgr.setSchedulingStrategy(LicenseSelectionStrategy::selectLicenseBasedOnLargerExpiry);
        licenseMgr.start();
        LicenseUtils.printCP4CCInfoLog(licenses);
        return handleLicenseChange;
    }

    @Provides
    @Inject
    public List<License> getCurrentLicenses(LicenseHolder licenseHolder) {
        return licenseHolder.getLicenses();
    }

    @Provides
    @Inject
    public License getCurrentLicense(LicenseHolder licenseHolder) {
        return licenseHolder.getCurrentLicense();
    }

    @Provides
    @Inject
    public LicenseManager getLicenseManager(LicenseHolder licenseHolder) {
        return licenseHolder.getLicenseManager();
    }
}

