/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.license;

import io.confluent.license.License;
import java.util.Date;
import java.util.List;

public class LicenseSelectionStrategy {
    private LicenseSelectionStrategy() {
    }

    public static License selectLicenseBasedOnLargerExpiry(List<License> licenses) {
        if (licenses == null || licenses.isEmpty()) {
            return null;
        }
        if (licenses.size() == 1) {
            return licenses.get(0);
        }
        return licenses.stream().max(LicenseSelectionStrategy::compareByExpiration).orElse(null);
    }

    private static int compareByExpiration(License l1, License l2) {
        Date exp1 = l1.expirationDate();
        Date exp2 = l2.expirationDate();
        if (exp1 == null && exp2 == null) {
            return LicenseSelectionStrategy.compareByDeploymentScope(l1, l2);
        }
        if (exp1 == null) {
            return -1;
        }
        if (exp2 == null) {
            return 1;
        }
        int dateComparison = exp1.compareTo(exp2);
        if (dateComparison == 0) {
            return LicenseSelectionStrategy.compareByDeploymentScope(l1, l2);
        }
        return dateComparison;
    }

    private static int compareByDeploymentScope(License l1, License l2) {
        License.DeploymentScope scope1 = l1.deploymentScope();
        License.DeploymentScope scope2 = l2.deploymentScope();
        if (scope1 == License.DeploymentScope.CP && scope2 == License.DeploymentScope.CP_FOR_CC) {
            return 1;
        }
        if (scope1 == License.DeploymentScope.CP_FOR_CC && scope2 == License.DeploymentScope.CP) {
            return -1;
        }
        return 0;
    }
}

