/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.controlcenter.httpclient.HttpCredential;
import io.confluent.controlcenter.rest.ProxyServlet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.proxy.AsyncMiddleManServlet;

public abstract class AbstractClusterLookupProxyServlet
extends ProxyServlet {
    protected abstract String lookupEndpoint(String var1);

    protected Response.CompleteListener newProxyResponseListener(HttpServletRequest clientRequest, HttpServletResponse proxyResponse) {
        String clusterId = this.extractClusterId(clientRequest);
        return new AbstractClusterLookupProxyResponseListener(clusterId, clientRequest, proxyResponse);
    }

    @Override
    protected String extractProxyUri(HttpServletRequest clientRequest) {
        String cluster = this.extractClusterId(clientRequest);
        if (cluster == null) {
            return null;
        }
        String path = clientRequest.getPathInfo();
        String proxyPath = path.substring(path.indexOf("/", 1));
        String endpoint = this.lookupEndpoint(cluster);
        return AbstractClusterLookupProxyServlet.composeProxyUri(endpoint, proxyPath, clientRequest.getQueryString());
    }

    protected void maybeAddBasicAuthHeader(HttpServletRequest clientRequest, Request proxyRequest, Map<String, HttpCredential> credentialsLookup) {
        HttpCredential credential = credentialsLookup.get(this.extractClusterId(clientRequest));
        if (credential != null) {
            proxyRequest.header(HttpHeader.AUTHORIZATION, null);
            proxyRequest.header(HttpHeader.AUTHORIZATION, credential.authorizationHeaderValue());
        }
    }

    @VisibleForTesting
    String extractClusterId(HttpServletRequest clientRequest) {
        int start;
        String path = clientRequest.getPathInfo();
        if (path == null || !path.startsWith("/") || (start = path.indexOf("/", 1)) < 0) {
            return null;
        }
        return path.substring(1, start);
    }

    protected void handleComplete(Result result, String clusterId) {
    }

    protected class AbstractClusterLookupProxyResponseListener
    extends AsyncMiddleManServlet.ProxyResponseListener {
        private final String clusterId;

        public AbstractClusterLookupProxyResponseListener(String clusterId, HttpServletRequest clientRequest, HttpServletResponse proxyResponse) {
            super((AsyncMiddleManServlet)AbstractClusterLookupProxyServlet.this, clientRequest, proxyResponse);
            this.clusterId = clusterId;
        }

        public void onComplete(Result result) {
            AbstractClusterLookupProxyServlet.this.handleComplete(result, this.clusterId);
            super.onComplete(result);
        }
    }
}

