/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.protobuf.ProtocolStringList;
import io.confluent.command.CommandUtil;
import io.confluent.command.kafka.CommandStore;
import io.confluent.command.record.Command;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterModule;
import io.confluent.controlcenter.ControlCenterRbacConfig;
import io.confluent.controlcenter.alert.SenderModule;
import io.confluent.controlcenter.alert.TriggerMetricTypes;
import io.confluent.controlcenter.alert.record.Alert;
import io.confluent.controlcenter.command.CommandModule;
import io.confluent.controlcenter.data.ClusterMetadataDaoUtils;
import io.confluent.controlcenter.data.ScopedKafkaMetadataDao;
import io.confluent.controlcenter.data.ScopedPermissions;
import io.confluent.controlcenter.rest.VisibleCluster;
import io.confluent.controlcenter.serialization.SerializationModule;
import io.confluent.controlcenter.streams.TopicStoreModule;
import io.confluent.controlcenter.util.KvQuery;
import io.confluent.controlcenter.util.ScopeUtils;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.serializers.OrderedKeyUberSerde;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/2.0/alerts")
@Produces(value={"application/json"})
public class AlertsResource {
    private static final Logger log = LoggerFactory.getLogger(AlertsResource.class);
    static final Ordering<Alert.AlertInfo> ALERT_INFO_ORDERING = new Ordering<Alert.AlertInfo>(){

        public int compare(Alert.AlertInfo left, Alert.AlertInfo right) {
            return Ordering.natural().reverse().onResultOf((Function)new Function<Alert.AlertInfo, Long>(){

                public Long apply(Alert.AlertInfo input) {
                    return input.getTimestamp();
                }
            }).nullsLast().compare((Object)left, (Object)right);
        }
    };
    private static final int COMMAND_TIMEOUT_SEC = 15;
    private static final String TRIGGER_WRITE_OPERATION = "ControlCenterTriggerWrite";
    private final Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> monitoringTriggerConfigs;
    private final Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> actionConfigs;
    private final CommandStore commandStore;
    private final Provider<ReadOnlyKeyValueStore<Bytes, Alert.AlertInfo>> alertHistoryStore;
    private final OrderedKeyUberSerde<Alert.AlertInfo> alertRangeSerde;
    public final AtomicBoolean alertsPaused;
    private final ControlCenterRbacConfig controlCenterRbacConfig;
    private final ControlCenterConfig controlCenterConfig;
    private final Map<String, Map<String, TriggerMetricTypes.MetricType>> triggerMetricTypesMap;
    private final List<String> triggerMetricList;
    private static final Map<CommandAlert.MonitoringTriggerConfig.ComponentCase, CommandAlert.MonitoringTriggerConfig.TriggerMetricCase> VALID_COMPONENT_TRIGGER = ImmutableMap.of((Object)CommandAlert.MonitoringTriggerConfig.ComponentCase.GROUP, (Object)CommandAlert.MonitoringTriggerConfig.TriggerMetricCase.METRIC, (Object)CommandAlert.MonitoringTriggerConfig.ComponentCase.BROKERCLUSTERS, (Object)CommandAlert.MonitoringTriggerConfig.TriggerMetricCase.BROKERMETRIC, (Object)CommandAlert.MonitoringTriggerConfig.ComponentCase.TOPIC, (Object)CommandAlert.MonitoringTriggerConfig.TriggerMetricCase.TOPICMETRIC);
    @Context
    @VisibleForTesting
    ScopedPermissions scopedPermissions;
    @Context
    @VisibleForTesting
    ScopedKafkaMetadataDao scopedKafkaMetadataDao;

    @Inject
    public AlertsResource(CommandStore commandStore, @CommandModule.TriggerConfigs Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> monitoringTriggerConfigs, @CommandModule.ActionConfigs Provider<ReadOnlyKeyValueStore<Command.CommandKey, Command.CommandMessage>> actionConfigs, @TopicStoreModule.AlertHistoryStore Provider<ReadOnlyKeyValueStore<Bytes, Alert.AlertInfo>> alertHistoryStore, @SerializationModule.TriggerEventsKeyPrefixSerde OrderedKeyUberSerde<Alert.AlertInfo> alertRangeSerde, @SenderModule.AlertsPaused AtomicBoolean alertsPaused, ControlCenterRbacConfig controlCenterRbacConfig, ControlCenterConfig controlCenterConfig, @ControlCenterModule.TriggerMetricTypesMap Map<String, Map<String, TriggerMetricTypes.MetricType>> triggerMetricTypesMap, @ControlCenterModule.TriggerMetricTypesList List<String> triggerMetricList) {
        this.commandStore = commandStore;
        this.monitoringTriggerConfigs = monitoringTriggerConfigs;
        this.actionConfigs = actionConfigs;
        this.alertHistoryStore = alertHistoryStore;
        this.alertRangeSerde = alertRangeSerde;
        this.alertsPaused = alertsPaused;
        this.controlCenterRbacConfig = controlCenterRbacConfig;
        this.controlCenterConfig = controlCenterConfig;
        this.triggerMetricTypesMap = triggerMetricTypesMap;
        this.triggerMetricList = triggerMetricList;
    }

    @GET
    @Path(value="/trigger-metric-types")
    public Map<String, Map<String, TriggerMetricTypes.MetricType>> getTriggerMetricTypesMap() {
        return this.triggerMetricTypesMap;
    }

    @GET
    @Path(value="/metadata")
    public Response getAlertsMetadata(@QueryParam(value="type") @DefaultValue(value="trigger-metrics") String type) {
        if (type.equals("trigger-metrics")) {
            return Response.ok(this.triggerMetricList).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        if (type.equals("trigger-source-metrics")) {
            return Response.ok(this.getTriggerMetricTypesMap()).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    @Path(value="/triggers/{guid}")
    public CommandAlert.MonitoringTriggerConfig getTrigger(@PathParam(value="guid") String guid) {
        Command.CommandKey key = CommandUtil.createCommandKey((String)guid, (Command.CommandConfigType)Command.CommandConfigType.MONITORING_TRIGGER_CONFIG);
        Command.CommandMessage baseMessage = (Command.CommandMessage)((ReadOnlyKeyValueStore)this.monitoringTriggerConfigs.get()).get((Object)key);
        if (baseMessage == null) {
            throw new NotFoundException("unable to find config with guid=" + guid);
        }
        CommandAlert.MonitoringTriggerConfig config = AlertsResource.externalizeClusterId(baseMessage.getMonitoringTriggerConfig());
        this.verifyTriggerAccess(config);
        return config;
    }

    @GET
    @Path(value="/triggers")
    public List<CommandAlert.MonitoringTriggerConfig> getTriggers() {
        ArrayList out = Lists.newArrayList();
        Set<String> clusterAlertsAccess = this.scopedPermissions.getAllClusterAlertsAccess();
        Set<String> visibilityAccess = this.scopedPermissions.getAllVisibleClusters();
        try (KeyValueIterator i = ((ReadOnlyKeyValueStore)this.monitoringTriggerConfigs.get()).all();){
            while (i.hasNext()) {
                CommandAlert.MonitoringTriggerConfig triggerConfig = AlertsResource.externalizeClusterId(((Command.CommandMessage)((KeyValue)i.next()).value).getMonitoringTriggerConfig());
                if (!this.canAccessTrigger(clusterAlertsAccess, visibilityAccess, triggerConfig)) continue;
                out.add(triggerConfig);
            }
        }
        return out;
    }

    @POST
    @Path(value="/triggers")
    public CommandAlert.MonitoringTriggerConfig createTrigger(CommandAlert.MonitoringTriggerConfig config) throws InterruptedException, ExecutionException, TimeoutException {
        if (!Strings.isNullOrEmpty((String)config.getGuid())) {
            return this.updateTrigger(config.getGuid(), config);
        }
        Set<String> clusterAlertsAccess = this.scopedPermissions.getAllClusterAlertsAccess();
        Set<String> visibilityAccess = this.scopedPermissions.getAllVisibleClusters();
        this.verifyMonitoringTriggerConfig(config, clusterAlertsAccess);
        config = AlertsResource.internalizeClusterIdBuilder(config).setGuid(UUID.randomUUID().toString()).build();
        this.verifyTriggerAccess(clusterAlertsAccess, visibilityAccess, config);
        log.trace("config={}", (Object)config);
        this.commandStore.update(CommandUtil.createCommandKey((String)config.getGuid(), (Command.CommandConfigType)Command.CommandConfigType.MONITORING_TRIGGER_CONFIG), Command.CommandMessage.newBuilder().setMonitoringTriggerConfig(config).build());
        return AlertsResource.externalizeClusterId(config);
    }

    @PUT
    @Path(value="/triggers/{guid}")
    public CommandAlert.MonitoringTriggerConfig updateTrigger(@PathParam(value="guid") String guid, CommandAlert.MonitoringTriggerConfig config) throws InterruptedException, ExecutionException, TimeoutException {
        if (!guid.equals(config.getGuid())) {
            throw new ClientErrorException("config guid does not match rest guid", Response.Status.CONFLICT);
        }
        Set<String> clusterAlertsAccess = this.scopedPermissions.getAllClusterAlertsAccess();
        Set<String> visibilityAccess = this.scopedPermissions.getAllVisibleClusters();
        this.verifyMonitoringTriggerConfig(config, clusterAlertsAccess);
        config = AlertsResource.internalizeClusterIdBuilder(config).build();
        Command.CommandKey key = CommandUtil.createCommandKey((String)guid, (Command.CommandConfigType)Command.CommandConfigType.MONITORING_TRIGGER_CONFIG);
        Command.CommandMessage baseMessage = (Command.CommandMessage)((ReadOnlyKeyValueStore)this.monitoringTriggerConfigs.get()).get((Object)key);
        this.verifyTriggerAccess(clusterAlertsAccess, visibilityAccess, baseMessage.getMonitoringTriggerConfig());
        log.trace("config={}", (Object)config);
        log.trace("baseMessage={}", (Object)baseMessage);
        if (!baseMessage.hasMonitoringTriggerConfig()) {
            throw new ClientErrorException("guid is not associated with a trigger", Response.Status.BAD_REQUEST);
        }
        if (!guid.equals(baseMessage.getMonitoringTriggerConfig().getGuid())) {
            throw new ClientErrorException("supplied guid does not match stored guid", Response.Status.CONFLICT);
        }
        this.commandStore.update(key, Command.CommandMessage.newBuilder((Command.CommandMessage)baseMessage).setMonitoringTriggerConfig(config).build());
        return AlertsResource.externalizeClusterId(config);
    }

    @DELETE
    @Path(value="/triggers/{guid}")
    public void deleteTrigger(@PathParam(value="guid") String guid) throws InterruptedException, ExecutionException, TimeoutException {
        Command.CommandKey key = CommandUtil.createCommandKey((String)guid, (Command.CommandConfigType)Command.CommandConfigType.MONITORING_TRIGGER_CONFIG);
        Command.CommandMessage baseMessage = (Command.CommandMessage)((ReadOnlyKeyValueStore)this.monitoringTriggerConfigs.get()).get((Object)key);
        if (baseMessage == null) {
            throw new NotFoundException("unable to find config with guid=" + guid);
        }
        this.verifyTriggerAccess(baseMessage.getMonitoringTriggerConfig());
        log.info("deleting trigger={} and removing from associated actions", (Object)guid);
        this.commandStore.update(key, null);
        ArrayList<Future> commandFutures = new ArrayList<Future>();
        try (KeyValueIterator i = ((ReadOnlyKeyValueStore)this.actionConfigs.get()).all();){
            while (i.hasNext()) {
                KeyValue keyValue = (KeyValue)i.next();
                if (!((Command.CommandMessage)keyValue.value).getActionConfig().getTriggerGuidList().contains((Object)guid)) continue;
                log.debug("removing trigger={} from action={}", (Object)guid, (Object)((Command.CommandKey)keyValue.key).getGuid());
                CommandAlert.ActionConfig.Builder acBuild = CommandAlert.ActionConfig.newBuilder((CommandAlert.ActionConfig)((Command.CommandMessage)keyValue.value).getActionConfig());
                acBuild.clearTriggerGuid();
                for (String triggerGuid : ((Command.CommandMessage)keyValue.value).getActionConfig().getTriggerGuidList()) {
                    if (triggerGuid.equals(guid)) continue;
                    acBuild.addTriggerGuid(triggerGuid);
                }
                commandFutures.add(this.commandStore.updateAsync((Command.CommandKey)keyValue.key, Command.CommandMessage.newBuilder((Command.CommandMessage)((Command.CommandMessage)keyValue.value)).setActionConfig(acBuild).build()));
            }
        }
        if (this.controlCenterRbacConfig.isRbacEnabled()) {
            for (Future f : commandFutures) {
                f.get(15L, TimeUnit.SECONDS);
            }
        }
    }

    @POST
    @Path(value="/actions")
    public CommandAlert.ActionConfig createAction(CommandAlert.ActionConfig config) throws InterruptedException, ExecutionException, TimeoutException {
        if (!Strings.isNullOrEmpty((String)config.getGuid())) {
            return this.updateAction(config.getGuid(), config);
        }
        this.verifyActionConfig(config);
        this.verifyActionAccess(config);
        config = CommandAlert.ActionConfig.newBuilder((CommandAlert.ActionConfig)config).setGuid(UUID.randomUUID().toString()).build();
        log.trace("config={}", (Object)config);
        this.commandStore.update(CommandUtil.createCommandKey((String)config.getGuid(), (Command.CommandConfigType)Command.CommandConfigType.ACTION_CONFIG), Command.CommandMessage.newBuilder().setActionConfig(config).build());
        return config;
    }

    @GET
    @Path(value="/actions/{guid}")
    public CommandAlert.ActionConfig getAction(@PathParam(value="guid") String guid) {
        Command.CommandKey key = CommandUtil.createCommandKey((String)guid, (Command.CommandConfigType)Command.CommandConfigType.ACTION_CONFIG);
        Command.CommandMessage baseMessage = (Command.CommandMessage)((ReadOnlyKeyValueStore)this.actionConfigs.get()).get((Object)key);
        if (baseMessage == null) {
            throw new NotFoundException("unable to find config with guid=" + guid);
        }
        this.verifyActionAccess(baseMessage.getActionConfig());
        return baseMessage.getActionConfig();
    }

    @GET
    @Path(value="/actions")
    public List<CommandAlert.ActionConfig> getActions() {
        ArrayList out = Lists.newArrayList();
        Set<String> clusterAlertsAccess = this.scopedPermissions.getAllClusterAlertsAccess();
        Set<String> visibilityAccess = this.scopedPermissions.getAllVisibleClusters();
        try (KeyValueIterator i = ((ReadOnlyKeyValueStore)this.actionConfigs.get()).all();){
            while (i.hasNext()) {
                CommandAlert.ActionConfig config = ((Command.CommandMessage)((KeyValue)i.next()).value).getActionConfig();
                if (!this.canAccessAction(clusterAlertsAccess, visibilityAccess, config)) continue;
                out.add(config);
            }
        }
        return out;
    }

    @PUT
    @Path(value="/actions/{guid}")
    public CommandAlert.ActionConfig updateAction(@PathParam(value="guid") String guid, CommandAlert.ActionConfig config) throws InterruptedException, ExecutionException, TimeoutException {
        if (!guid.equals(config.getGuid())) {
            throw new ClientErrorException("config guid does not match rest guid", Response.Status.CONFLICT);
        }
        this.verifyActionConfig(config);
        this.verifyActionAccess(config);
        Command.CommandKey key = CommandUtil.createCommandKey((String)guid, (Command.CommandConfigType)Command.CommandConfigType.ACTION_CONFIG);
        Command.CommandMessage baseMessage = (Command.CommandMessage)((ReadOnlyKeyValueStore)this.actionConfigs.get()).get((Object)key);
        log.trace("config={}", (Object)config);
        log.trace("baseMessage={}", (Object)baseMessage);
        this.commandStore.update(key, Command.CommandMessage.newBuilder((Command.CommandMessage)baseMessage).setActionConfig(config).build());
        return config;
    }

    @DELETE
    @Path(value="/actions/{guid}")
    public void deleteAction(@PathParam(value="guid") String guid) throws InterruptedException, ExecutionException, TimeoutException {
        Command.CommandKey key = CommandUtil.createCommandKey((String)guid, (Command.CommandConfigType)Command.CommandConfigType.ACTION_CONFIG);
        Command.CommandMessage baseMessage = (Command.CommandMessage)((ReadOnlyKeyValueStore)this.actionConfigs.get()).get((Object)key);
        if (baseMessage == null) {
            throw new NotFoundException("unable to find config with guid=" + guid);
        }
        this.verifyActionAccess(baseMessage.getActionConfig());
        this.commandStore.update(key, null);
    }

    @GET
    @Path(value="history")
    public List<Alert.AlertInfo> getHistory(@QueryParam(value="ts") Long timestamp, @QueryParam(value="guid") @DefaultValue(value="") String guid, @QueryParam(value="limit") @DefaultValue(value="50") Long limit) {
        if (limit > 500L) {
            throw new ClientErrorException("limit must be < 500", Response.Status.BAD_REQUEST);
        }
        ArrayList out = Lists.newArrayList();
        Bytes startKey = null;
        if (timestamp != null) {
            startKey = this.alertRangeSerde.key((Object)Alert.AlertInfo.newBuilder().setGuid(guid).setTimestamp(timestamp.longValue()).build());
        }
        Set<String> clusterAlertsAccess = this.scopedPermissions.getAllClusterAlertsAccess();
        Set<String> visibilityAccess = this.scopedPermissions.getAllVisibleClusters();
        try (KeyValueIterator iter = KvQuery.rangeFrom((ReadOnlyKeyValueStore)this.alertHistoryStore.get(), startKey);){
            while (iter.hasNext() && (long)out.size() < limit) {
                Alert.AlertInfo alert = AlertsResource.externalizeClusterId((Alert.AlertInfo)((KeyValue)iter.next()).value);
                if (!this.canAccessAlert(clusterAlertsAccess, visibilityAccess, alert)) continue;
                out.add(alert);
            }
        }
        return ALERT_INFO_ORDERING.sortedCopy((Iterable)out);
    }

    @POST
    @Path(value="/actions/pause")
    public Response pauseActions() {
        this.verifyPauseActionsAccess();
        this.alertsPaused.compareAndSet(false, true);
        return Response.accepted().build();
    }

    @POST
    @Path(value="/actions/resume")
    public Response resumeActions() {
        this.verifyPauseActionsAccess();
        this.alertsPaused.compareAndSet(true, false);
        return Response.accepted().build();
    }

    @GET
    @Path(value="/actions/pausedStatus")
    public Response pausedStatus() {
        return Response.ok().entity((Object)this.alertsPaused.get()).build();
    }

    @GET
    @Path(value="/permissions/{clusterId}/groups")
    public Set<String> getAccessibleGroups(@PathParam(value="clusterId") VisibleCluster cluster) throws InterruptedException, ExecutionException, TimeoutException {
        String clusterId = cluster.getClusterId();
        Set<String> visibleGroups = this.scopedKafkaMetadataDao.getConsumerGroups(clusterId);
        if (this.scopedPermissions.hasClusterAlertsAccess(clusterId)) {
            return visibleGroups;
        }
        return this.scopedPermissions.authorizeAll(visibleGroups.stream().collect(Collectors.toMap(group -> group, group -> AlertsResource.getAuthorizeActionsForGroup(clusterId, group))));
    }

    @GET
    @Path(value="/permissions/{clusterId}/topics")
    public Set<String> getAccessibleTopics(@PathParam(value="clusterId") VisibleCluster cluster) throws InterruptedException, ExecutionException, TimeoutException {
        String clusterId = cluster.getClusterId();
        ImmutableSet visibleTopics = ImmutableSet.copyOf(this.scopedKafkaMetadataDao.getTopicNamesFromMetadataOrCache(clusterId));
        if (this.scopedPermissions.hasClusterAlertsAccess(clusterId)) {
            return visibleTopics;
        }
        return this.scopedPermissions.authorizeAll(visibleTopics.stream().distinct().collect(Collectors.toMap(topic -> topic, topic -> AlertsResource.getAuthorizeActionsForTopic(clusterId, topic))));
    }

    private void verifyPauseActionsAccess() {
        if (!this.canPauseActions()) {
            throw new ForbiddenException("must be SystemAdmin on MDS cluster to pause actions");
        }
    }

    private boolean canPauseActions() {
        return this.scopedPermissions.isSuperUser();
    }

    private void verifyTriggerAccess(CommandAlert.MonitoringTriggerConfig config) {
        if (!this.canAccessTrigger(config)) {
            throw new ForbiddenException("cannot access trigger");
        }
    }

    private void verifyTriggerAccess(Set<String> clusterAlertsAccess, Set<String> visibilityAccess, CommandAlert.MonitoringTriggerConfig config) {
        if (!this.canAccessTrigger(clusterAlertsAccess, visibilityAccess, config)) {
            throw new ForbiddenException("cannot access trigger");
        }
    }

    private boolean canAccessTrigger(CommandAlert.MonitoringTriggerConfig config) {
        return this.canAccessTrigger(this.scopedPermissions.getAllClusterAlertsAccess(), this.scopedPermissions.getAllVisibleClusters(), config);
    }

    private boolean canAccessTrigger(Set<String> clusterAlertsAccess, Set<String> visibilityAccess, CommandAlert.MonitoringTriggerConfig config) {
        if (this.controlCenterRbacConfig.isRbacEnabled()) {
            Set<String> triggerClusters = AlertsResource.getTriggerClusters(config);
            if (config.getComponentCase() == CommandAlert.MonitoringTriggerConfig.ComponentCase.TOPIC) {
                Preconditions.checkArgument((triggerClusters.size() == 1 ? 1 : 0) != 0);
                String clusterId = triggerClusters.iterator().next();
                if (!clusterAlertsAccess.contains(clusterId)) {
                    if (!config.getTopic().getFilter().equals((Object)CommandAlert.TopicNameFilter.EQUALS)) {
                        return false;
                    }
                    if (!this.scopedPermissions.authorize(AlertsResource.getAuthorizeActionsForTopic(clusterId, config.getTopic().getValue()))) {
                        return false;
                    }
                }
            } else if (config.getComponentCase() == CommandAlert.MonitoringTriggerConfig.ComponentCase.GROUP) {
                Preconditions.checkArgument((triggerClusters.size() == 1 ? 1 : 0) != 0);
                String clusterId = triggerClusters.iterator().next();
                if (!clusterAlertsAccess.contains(clusterId) && !this.scopedPermissions.authorize(AlertsResource.getAuthorizeActionsForGroup(clusterId, config.getGroup()))) {
                    return false;
                }
            } else if (!clusterAlertsAccess.containsAll(triggerClusters)) {
                return false;
            }
        }
        return true;
    }

    private void verifyActionAccess(CommandAlert.ActionConfig config) {
        Set<String> visibilityAccess;
        Set<String> clusterAlertsAccess = this.scopedPermissions.getAllClusterAlertsAccess();
        if (!this.canAccessAction(clusterAlertsAccess, visibilityAccess = this.scopedPermissions.getAllVisibleClusters(), config)) {
            throw new ForbiddenException("no access to this action");
        }
    }

    private boolean canAccessAction(Set<String> clusterAlertsAccess, Set<String> visibilityAccess, CommandAlert.ActionConfig config) {
        for (String triggerGuid : config.getTriggerGuidList()) {
            Command.CommandKey key = CommandUtil.createCommandKey((String)triggerGuid, (Command.CommandConfigType)Command.CommandConfigType.MONITORING_TRIGGER_CONFIG);
            Command.CommandMessage baseMessage = (Command.CommandMessage)((ReadOnlyKeyValueStore)this.monitoringTriggerConfigs.get()).get((Object)key);
            if (!(baseMessage == null ? this.controlCenterRbacConfig.isRbacEnabled() : !this.canAccessTrigger(clusterAlertsAccess, visibilityAccess, baseMessage.getMonitoringTriggerConfig()))) continue;
            return false;
        }
        return true;
    }

    private boolean canAccessAlert(Set<String> clusterAlertsAccess, Set<String> visibilityAccess, Alert.AlertInfo alertInfo) {
        return this.canAccessTrigger(clusterAlertsAccess, visibilityAccess, alertInfo.getMonitoringTrigger());
    }

    @VisibleForTesting
    void verifyActionConfig(CommandAlert.ActionConfig config) {
        if (config.getIntervalMs() < 0L) {
            throw new ClientErrorException("intervalMs must be >=0", Response.Status.BAD_REQUEST);
        }
        boolean activeControllerTriggerEnabled = this.controlCenterConfig.getBoolean("confluent.controlcenter.trigger.active-controller-count.enable");
        for (String triggerGuid : config.getTriggerGuidList()) {
            Command.CommandMessage message = (Command.CommandMessage)((ReadOnlyKeyValueStore)this.monitoringTriggerConfigs.get()).get((Object)CommandUtil.createCommandKey((String)triggerGuid, (Command.CommandConfigType)Command.CommandConfigType.MONITORING_TRIGGER_CONFIG));
            AlertsResource.verifyActionConfigMessage(triggerGuid, message, activeControllerTriggerEnabled);
        }
    }

    @VisibleForTesting
    static void verifyActionConfigMessage(String triggerGuid, Command.CommandMessage message, boolean activeControllerTriggerEnabled) {
        if (message == null) {
            throw new ClientErrorException("invalid triggerGuid=" + triggerGuid, Response.Status.BAD_REQUEST);
        }
        if (message.getMonitoringTriggerConfig().getBrokerMetric() == CommandAlert.BrokerTriggerMetricType.ACTIVE_CONTROLLER_COUNT && !activeControllerTriggerEnabled) {
            throw new ClientErrorException("Invalid trigger: Active Controller Count triggers are no longer supported. Please modify or delete this trigger. triggerGuid=" + triggerGuid, Response.Status.BAD_REQUEST);
        }
    }

    @VisibleForTesting
    void verifyMonitoringTriggerConfig(CommandAlert.MonitoringTriggerConfig config, Set<String> clusterAlertsAccess) {
        AlertsResource.verifyMonitoringTriggerConfig(config, clusterAlertsAccess, this.controlCenterRbacConfig.isRbacEnabled(), this.controlCenterConfig.getBoolean("confluent.controlcenter.trigger.active-controller-count.enable"));
    }

    static void verifyMonitoringTriggerConfig(CommandAlert.MonitoringTriggerConfig config, Set<String> clusterAlertsAccess, boolean rbacEnabled, boolean activeControllerTriggerEnabled) {
        if (config.getLagMs() < 0L) {
            throw new ClientErrorException("lagMs must be >=0", Response.Status.BAD_REQUEST);
        }
        if (!VALID_COMPONENT_TRIGGER.containsKey(config.getComponentCase())) {
            throw new ClientErrorException("Must specify component", Response.Status.BAD_REQUEST);
        }
        if (VALID_COMPONENT_TRIGGER.get(config.getComponentCase()) != config.getTriggerMetricCase()) {
            throw new ClientErrorException("Invalid component/trigger pair: component=" + config.getComponentCase() + " trigger=" + config.getTriggerMetricCase(), Response.Status.BAD_REQUEST);
        }
        if (config.getBrokerMetric() == CommandAlert.BrokerTriggerMetricType.ZK_STATUS || config.getBrokerMetric() == CommandAlert.BrokerTriggerMetricType.CLUSTER_STATUS) {
            if (config.getValueCase() != CommandAlert.MonitoringTriggerConfig.ValueCase.STATUSVALUE) {
                throw new ClientErrorException("Must specify statusValue", Response.Status.BAD_REQUEST);
            }
        } else if (config.getValueCase() != CommandAlert.MonitoringTriggerConfig.ValueCase.LONGVALUE) {
            throw new ClientErrorException("Must specify longValue", Response.Status.BAD_REQUEST);
        }
        if (!activeControllerTriggerEnabled && config.getBrokerMetric() == CommandAlert.BrokerTriggerMetricType.ACTIVE_CONTROLLER_COUNT) {
            throw new ClientErrorException("Invalid trigger: Active Controller Count triggers are no longer supported. Please modify or delete this trigger.", Response.Status.BAD_REQUEST);
        }
    }

    private static Set<String> getTriggerClusters(CommandAlert.MonitoringTriggerConfig config) {
        ProtocolStringList brokerClusters = config.getBrokerClusters().getBrokerClustersList();
        if (brokerClusters.isEmpty()) {
            return ImmutableSet.of((Object)config.getClusterId());
        }
        return ImmutableSet.copyOf((Collection)brokerClusters);
    }

    private static CommandAlert.MonitoringTriggerConfig.Builder internalizeClusterIdBuilder(CommandAlert.MonitoringTriggerConfig config) {
        return CommandAlert.MonitoringTriggerConfig.newBuilder((CommandAlert.MonitoringTriggerConfig)config).setClusterId(ClusterMetadataDaoUtils.getInternalKafkaId(config.getClusterId()));
    }

    private static CommandAlert.MonitoringTriggerConfig externalizeClusterId(CommandAlert.MonitoringTriggerConfig config) {
        return CommandAlert.MonitoringTriggerConfig.newBuilder((CommandAlert.MonitoringTriggerConfig)config).setClusterId(ClusterMetadataDaoUtils.getExternalKafkaId(config.getClusterId())).build();
    }

    private static Alert.AlertInfo externalizeClusterId(Alert.AlertInfo alertInfo) {
        return Alert.AlertInfo.newBuilder((Alert.AlertInfo)alertInfo).setMonitoringTrigger(AlertsResource.externalizeClusterId(alertInfo.getMonitoringTrigger())).build();
    }

    private static List<Action> getAuthorizeActionsForGroup(String clusterId, String group) {
        return AlertsResource.getAuthorizeActions(clusterId, "Group", group);
    }

    private static List<Action> getAuthorizeActionsForTopic(String clusterId, String topic) {
        return AlertsResource.getAuthorizeActions(clusterId, "Topic", topic);
    }

    private static List<Action> getAuthorizeActions(String clusterId, String resourceType, String resource) {
        return ImmutableList.of((Object)new Action(ScopeUtils.buildKafkaScope(clusterId), new ResourceType(resourceType), resource, new Operation(TRIGGER_WRITE_OPERATION)));
    }
}

