/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.base.MoreObjects;
import io.confluent.common.security.auth.ApiKeyPrincipal;
import io.confluent.controlcenter.rest.AdminVisitor;
import io.confluent.controlcenter.rest.ClusterCredential;
import java.util.Objects;
import org.apache.kafka.clients.admin.Admin;

public class ApiKeyCredential
extends ClusterCredential {
    public final String apiKey;
    public final String apiSecret;

    private ApiKeyCredential(String cluster, String apiKey, String apiSecret) {
        super(cluster);
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
    }

    public static ApiKeyCredential makeCredentialFromApiKeyPrincipal(String clusterId, ApiKeyPrincipal principal) {
        if (principal == null) {
            throw new IllegalArgumentException("invalid principal");
        }
        return new ApiKeyCredential(clusterId, principal.getName(), principal.getSecret());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiKeyCredential that = (ApiKeyCredential)o;
        return Objects.equals(this.cluster, that.cluster) && Objects.equals(this.apiKey, that.apiKey) && Objects.equals(this.apiSecret, that.apiSecret);
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.apiKey, this.apiSecret);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("cluster", (Object)this.cluster).add("apiKey", (Object)this.apiKey).toString();
    }

    @Override
    public Admin accept(AdminVisitor adminVisitor) {
        return adminVisitor.visit(this);
    }
}

