/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.confluent.controlcenter.annotation.Environment;
import io.confluent.controlcenter.annotation.Mode;
import io.confluent.controlcenter.util.ReflectionsUtils;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import org.reflections.Reflections;

class AvailableResourceFilter
implements Filter {
    @VisibleForTesting
    static final String ERROR_MSG = "resource not available in the current C3 mode";
    private Mode.ModeType modeType;
    private final Reflections reflections;
    private final List<String> disallowedPaths;
    private final Predicate<Class<?>> predicate = aClass -> {
        int modifiers = aClass.getModifiers();
        Environment env = aClass.getAnnotation(Environment.class);
        Mode mode = aClass.getAnnotation(Mode.class);
        return !Modifier.isAbstract(modifiers) && (env == null || env.environment() == Environment.EnvType.ON_PREM) && mode != null && mode.mode() != this.modeType;
    };
    private final Function<Class<?>, String> function = aClass -> {
        String path = aClass.getAnnotation(Path.class).value();
        return path.split("/\\{")[0];
    };

    @Inject
    public AvailableResourceFilter(Mode.ModeType modeType, Reflections reflections) {
        this.modeType = modeType;
        this.reflections = reflections;
        this.disallowedPaths = this.getDisallowedPaths();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String targetPath = ((HttpServletRequest)request).getPathInfo();
        if (targetPath.startsWith("/2.0/status/app_info")) {
            chain.doFilter(request, response);
        } else if (this.disallowedPaths.stream().anyMatch(targetPath::startsWith)) {
            ((HttpServletResponse)response).sendError(404, ERROR_MSG);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    @VisibleForTesting
    List<String> getDisallowedPaths() {
        ImmutableList.Builder builder = ImmutableList.builder();
        ReflectionsUtils.getTypesAnnotatedWith(this.reflections, Path.class, builder, this.predicate, this.function);
        if (this.modeType == Mode.ModeType.MANAGEMENT) {
            builder.add((Object)"/2.0/alerts/history");
        }
        return builder.build();
    }
}

