/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.collect.Lists;
import io.confluent.controlcenter.annotation.Environment;
import io.confluent.controlcenter.data.ConsumerOffsetsDao;
import io.confluent.controlcenter.data.ConsumerOffsetsDaoSupplier;
import io.confluent.controlcenter.rest.res.ConsumerGroup;
import io.confluent.controlcenter.rest.res.ConsumerGroupOffsets;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.kafka.common.IsolationLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(environment=Environment.EnvType.CLOUD)
@Path(value="/2.0/consumer/offsets/{clusterId}")
@Produces(value={"application/json"})
public class ConsumerOffsetsResource {
    private static final Logger log = LoggerFactory.getLogger(ConsumerOffsetsResource.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @PerformanceMetric(value="kafka.consumer_groups.get")
    public List<ConsumerGroup> all(@PathParam(value="clusterId") ConsumerOffsetsDaoSupplier daoSupplier) {
        try (ConsumerOffsetsDao consumerOffsetsDao = (ConsumerOffsetsDao)daoSupplier.get();){
            Map<String, ConsumerGroupOffsets> cgOffsets = consumerOffsetsDao.getAllConsumerGroupOffsets();
            ArrayList arrayList = Lists.newArrayList((Iterable)cgOffsets.values().stream().map(ConsumerGroup::new).collect(Collectors.toList()));
            return arrayList;
        }
        catch (Exception e) {
            log.warn("unable to fetch offsets for consumer groups", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/{consumerGroupId}")
    public ConsumerGroupOffsets consumerGroup(@PathParam(value="clusterId") ConsumerOffsetsDaoSupplier daoSupplier, @PathParam(value="consumerGroupId") String consumerGroupId, @QueryParam(value="isolationLevel") @DefaultValue(value="read_committed") String isolationLevel) {
        try (ConsumerOffsetsDao consumerOffsetsDao = (ConsumerOffsetsDao)daoSupplier.get();){
            ConsumerGroupOffsets consumerGroupOffsets = consumerOffsetsDao.getConsumerGroupOffsets(consumerGroupId, this.parseIsolationLevel(isolationLevel));
            return consumerGroupOffsets;
        }
        catch (Exception e) {
            log.warn("unable to fetch offsets for consumer group={}", (Object)consumerGroupId, (Object)e);
            return null;
        }
    }

    private IsolationLevel parseIsolationLevel(String isolationLevel) {
        if (isolationLevel == null || isolationLevel.isEmpty()) {
            return IsolationLevel.READ_COMMITTED;
        }
        switch (isolationLevel.toLowerCase(Locale.ROOT)) {
            case "read_uncommitted": {
                return IsolationLevel.READ_UNCOMMITTED;
            }
            case "read_committed": {
                return IsolationLevel.READ_COMMITTED;
            }
        }
        throw new IllegalArgumentException("Unknown isolation level " + isolationLevel);
    }
}

