/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import io.confluent.controlcenter.kafka.AdminSupplier;
import io.confluent.controlcenter.kafka.ProducerSupplier;
import io.confluent.controlcenter.rest.ControlCenterKafkaRestModule;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.controlcenter.util.PrincipalUtils;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.v2.KafkaConsumerManager;
import java.security.Principal;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.Producer;

final class ControlCenterKafkaRestContext
implements KafkaRestContext {
    private final AdminSupplier<TokenCredential> adminClientSupplier;
    private final String clusterId;
    private final KafkaRestConfig config;
    private final ProducerSupplier<byte[], byte[]> producerSupplier;
    private final SecurityContext securityContext;

    @Inject
    ControlCenterKafkaRestContext(AdminSupplier<TokenCredential> adminClientSupplier, @ControlCenterKafkaRestModule.ClusterId String clusterId, KafkaRestConfig config, ProducerSupplier<byte[], byte[]> producerSupplier, @Context SecurityContext securityContext) {
        this.adminClientSupplier = Objects.requireNonNull(adminClientSupplier);
        this.clusterId = Objects.requireNonNull(clusterId);
        this.config = Objects.requireNonNull(config);
        this.producerSupplier = Objects.requireNonNull(producerSupplier);
        this.securityContext = Objects.requireNonNull(securityContext);
    }

    public KafkaRestConfig getConfig() {
        return this.config;
    }

    public KafkaConsumerManager getKafkaConsumerManager() {
        throw new UnsupportedOperationException();
    }

    public Admin getAdmin() {
        return this.adminClientSupplier.getClient(TokenCredential.makeCredentialFromJwtOrNullPrincipal(this.clusterId, (Principal)PrincipalUtils.jwtPrincipalOrNull(this.securityContext)));
    }

    public Producer<byte[], byte[]> getProducer() {
        return this.producerSupplier.getProducer(TokenCredential.makeCredentialFromJwtOrNullPrincipal(this.clusterId, (Principal)PrincipalUtils.jwtPrincipalOrNull(this.securityContext)));
    }

    public void shutdown() {
    }
}

