/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.kafka.AdminSupplier;
import io.confluent.controlcenter.kafka.ProducerSupplier;
import io.confluent.controlcenter.rest.ControlCenterKafkaRestContext;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.kafkarest.KafkaRestContext;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import javax.inject.Provider;
import javax.inject.Qualifier;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.Producer;
import org.glassfish.hk2.api.AnnotationLiteral;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.process.internal.RequestScoped;

@Singleton
final class ControlCenterKafkaRestModule
extends AbstractBinder {
    private final AdminSupplier<TokenCredential> adminClientSupplier;
    private final ProducerSupplier<byte[], byte[]> producerSupplier;

    @Inject
    ControlCenterKafkaRestModule(AdminSupplier<TokenCredential> adminClientSupplier, ProducerSupplier<byte[], byte[]> producerSupplier) {
        this.adminClientSupplier = Objects.requireNonNull(adminClientSupplier);
        this.producerSupplier = Objects.requireNonNull(producerSupplier);
    }

    protected void configure() {
        this.bind(this.adminClientSupplier).to((TypeLiteral)new TypeLiteral<AdminSupplier<TokenCredential>>(){});
        this.bind(this.producerSupplier).to((TypeLiteral)new TypeLiteral<ProducerSupplier<byte[], byte[]>>(){});
        this.bindFactory(ClusterIdFactory.class).qualifiedBy((Annotation)new ClusterIdImpl()).to(String.class).in(RequestScoped.class);
        this.bind(ControlCenterKafkaRestContext.class).to(KafkaRestContext.class).in(RequestScoped.class).ranked(1);
        this.bindFactory(AdminFactory.class).to(Admin.class).in(RequestScoped.class).ranked(1);
        this.bindFactory(ProducerFactory.class).to((TypeLiteral)new TypeLiteral<Producer<byte[], byte[]>>(){}).in(RequestScoped.class).ranked(1);
    }

    private static final class ProducerFactory
    implements Factory<Producer<byte[], byte[]>> {
        private final Provider<KafkaRestContext> context;

        @javax.inject.Inject
        private ProducerFactory(Provider<KafkaRestContext> context) {
            this.context = Objects.requireNonNull(context);
        }

        public Producer<byte[], byte[]> provide() {
            return ((KafkaRestContext)this.context.get()).getProducer();
        }

        public void dispose(Producer<byte[], byte[]> producer) {
            producer.close();
        }
    }

    private static final class AdminFactory
    implements Factory<Admin> {
        private final Provider<KafkaRestContext> context;

        @javax.inject.Inject
        private AdminFactory(Provider<KafkaRestContext> context) {
            this.context = Objects.requireNonNull(context);
        }

        public Admin provide() {
            return ((KafkaRestContext)this.context.get()).getAdmin();
        }

        public void dispose(Admin admin) {
            admin.close();
        }
    }

    private static final class ClusterIdFactory
    implements Factory<String> {
        private final Provider<UriInfo> uriInfo;

        @javax.inject.Inject
        private ClusterIdFactory(@Context Provider<UriInfo> uriInfo) {
            this.uriInfo = Objects.requireNonNull(uriInfo);
        }

        public String provide() {
            return ((UriInfo)this.uriInfo.get()).getPath(false).split("/")[2];
        }

        public void dispose(String clusterId) {
        }
    }

    private static final class ClusterIdImpl
    extends AnnotationLiteral<ClusterId>
    implements ClusterId {
        private ClusterIdImpl() {
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER})
    public static @interface ClusterId {
    }
}

