/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.github.zafarkhaja.semver.Version;
import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.healthcheck.HealthCheckModule;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

class CustomHeaderFilter
implements Filter {
    static final String X_CONFLUENT_CONTROL_CENTER_VERSION_HEADER = "X-Confluent-Control-Center-Version";
    static final String X_CONFLUENT_CONTROL_CENTER_SESSION_HEADER = "X-Confluent-Control-Session";
    static final String STRICT_TRANSPORT_SECURITY_HEADER = "Strict-Transport-Security";
    static final String STRICT_TRANSPORT_SECURITY_VALUE = "max-age=31536000";
    static final String CACHE_CONTROL_HEADER = "Cache-Control";
    static final String CACHE_CONTROL_VALUE = "no-store";
    static final String X_FRAME_OPTIONS = "X-Frame-Options";
    private ControlCenterConfig controlCenterConfig;
    private final Version version;
    private final String sessionId;

    @Inject
    public CustomHeaderFilter(ControlCenterConfig controlCenterConfig, Version version, @HealthCheckModule.SessionId String sessionId) {
        this.controlCenterConfig = controlCenterConfig;
        this.version = version;
        this.sessionId = sessionId;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.setHeader(X_CONFLUENT_CONTROL_CENTER_VERSION_HEADER, this.version.toString());
        httpServletResponse.setHeader(X_CONFLUENT_CONTROL_CENTER_SESSION_HEADER, this.sessionId);
        if (this.controlCenterConfig.getBoolean("confluent.controlcenter.rest.hsts.enable").booleanValue()) {
            httpServletResponse.setHeader(STRICT_TRANSPORT_SECURITY_HEADER, STRICT_TRANSPORT_SECURITY_VALUE);
        }
        if (!this.controlCenterConfig.getString("confluent.controlcenter.rest.response.http.headers.config").contains(CACHE_CONTROL_HEADER)) {
            httpServletResponse.setHeader(CACHE_CONTROL_HEADER, CACHE_CONTROL_VALUE);
        }
        httpServletResponse.setHeader(X_FRAME_OPTIONS, "SAMEORIGIN");
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

