/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.data.PermissionsService;
import io.confluent.controlcenter.kafka.ClusterChangeEvent;
import io.confluent.controlcenter.rest.ApplicationBase;
import io.confluent.controlcenter.rest.ControlCenterKafkaRestModule;
import io.confluent.controlcenter.rest.CustomHeaderFilter;
import io.confluent.controlcenter.rest.ReadOnlyRolesFilter;
import io.confluent.controlcenter.rest.RestSecuritySetup;
import io.confluent.controlcenter.util.ConfigUtils;
import io.confluent.controlcenter.util.PrincipalUtils;
import io.confluent.controlcenter.util.ScopeUtils;
import io.confluent.kafkarest.KafkaRestApplication;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestResourceExtension;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.auth.AuthUtil;
import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;

@Singleton
@InterfaceStability.Evolving
public class KafkaRestApplications
extends Application<RestConfig>
implements ApplicationBase {
    private final ControlCenterConfig controlCenterConfig;
    private final RestSecuritySetup restSecuritySetup;
    private final CustomHeaderFilter responseHeaderFilter;
    private final ReadOnlyRolesFilter readOnlyRolesFilter;
    private final ControlCenterKafkaRestModule controlCenterKafkaRestModule;
    private final PermissionsService permissionsService;
    private final RestConfig restConfig;
    private HandlerCollection handlers = new HandlerCollection(true, new Handler[0]);
    private HandlerCollection wsHandlers = new HandlerCollection(true, new Handler[0]);

    @Inject
    public KafkaRestApplications(RestConfig restConfig, ControlCenterConfig controlCenterConfig, CustomHeaderFilter responseHeaderFilter, ReadOnlyRolesFilter readOnlyRolesFilter, RestSecuritySetup restSecuritySetup, ControlCenterKafkaRestModule controlCenterKafkaRestModule, PermissionsService permissionsService) {
        super(restConfig);
        this.restConfig = restConfig;
        this.controlCenterConfig = controlCenterConfig;
        this.responseHeaderFilter = responseHeaderFilter;
        this.readOnlyRolesFilter = readOnlyRolesFilter;
        this.restSecuritySetup = restSecuritySetup;
        this.controlCenterKafkaRestModule = Objects.requireNonNull(controlCenterKafkaRestModule);
        this.permissionsService = permissionsService;
    }

    @Subscribe
    public void registerCluster(ClusterChangeEvent clusterChangeEvent) throws Exception {
        EmbeddedKafkaRestApplication application = new EmbeddedKafkaRestApplication(this.getKafkaRestConfig(clusterChangeEvent.getConfig(), clusterChangeEvent.getClusterId()), this.controlCenterConfig.getString("confluent.controlcenter.ui.basepath"), clusterChangeEvent.getClusterId());
        this.addHandler(application.configureHandler(), this.handlers);
        this.addHandler(application.configureWebSocketHandler(), this.wsHandlers);
    }

    private void addHandler(Handler handler, HandlerCollection parent) throws Exception {
        parent.addHandler(handler);
        if (parent.isStarted()) {
            handler.start();
        }
    }

    KafkaRestConfig getKafkaRestConfig(Map<String, Object> configs, String clusterId) {
        Properties props = new Properties();
        for (Map.Entry<String, Object> config : configs.entrySet()) {
            props.put(config.getKey(), config.getValue() instanceof List ? ConfigUtils.toString((List)config.getValue()) : config.getValue().toString());
        }
        props.put("kafka.rest.resource.extension.class", KafkaRestResourceExtension.class.getName());
        props.put("websocket.path.prefix", String.format("/api/kafka-rest-ws/%s", clusterId));
        return new KafkaRestConfig(props);
    }

    public Handler configureHandler() {
        return this.handlers;
    }

    public Handler configureWebSocketHandler() {
        return this.wsHandlers;
    }

    public void setupResources(Configurable<?> configurable, RestConfig restConfig) {
    }

    public static final class ClusterAccessFilter
    implements Filter {
        private final PermissionsService permissionsService;
        @Context
        Provider<SecurityContext> securityContext;

        public ClusterAccessFilter(PermissionsService permissionsService) {
            this.permissionsService = permissionsService;
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            String clusterId = ((HttpServletRequest)request).getPathInfo().split("/")[3];
            Principal userPrincipal = ((HttpServletRequest)request).getUserPrincipal();
            if (!this.permissionsService.isVisible(PrincipalUtils.jwtPrincipalOrNull(userPrincipal), ScopeUtils.buildKafkaScope(clusterId))) {
                throw new ForbiddenException("must have cluster view access");
            }
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }

    final class EmbeddedKafkaRestApplication
    extends KafkaRestApplication
    implements ApplicationBase {
        public EmbeddedKafkaRestApplication(KafkaRestConfig config, String basePath, String clusterId) {
            super(config, String.format(basePath + "api/kafka-rest/%s/kafka", clusterId));
        }

        public void setupResources(Configurable<?> config, KafkaRestConfig appConfig) {
            super.setupResources(config, appConfig);
            config.register((Object)KafkaRestApplications.this.controlCenterKafkaRestModule);
        }

        public void configurePreResourceHandling(ServletContextHandler context) {
            super.configurePreResourceHandling(context);
            context.addFilter(new FilterHolder((Filter)KafkaRestApplications.this.readOnlyRolesFilter), "/*", null);
            context.addFilter(new FilterHolder((Filter)KafkaRestApplications.this.responseHeaderFilter), "/*", null);
            context.addFilter(new FilterHolder((Filter)new ClusterAccessFilter(KafkaRestApplications.this.permissionsService)), "/*", null);
        }

        public void configurePostResourceHandling(ServletContextHandler context) {
            long authTimeout = KafkaRestApplications.this.controlCenterConfig.getLong("confluent.controlcenter.auth.session.expiration.ms");
            if (authTimeout > 0L) {
                context.getSessionHandler().setMaxInactiveInterval((int)TimeUnit.SECONDS.toSeconds(authTimeout));
            }
            this.configureErrorHandler(context);
        }

        protected void configureSecurityHandler(ServletContextHandler context) {
            super.configureSecurityHandler(context);
            ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
            if (KafkaRestApplications.this.restSecuritySetup.getRealm() != null) {
                securityHandler.addConstraintMapping(AuthUtil.createSecuredConstraint((RestConfig)KafkaRestApplications.this.restConfig, (String)"/*"));
            }
            securityHandler.setRealmName(KafkaRestApplications.this.restSecuritySetup.getRealm());
            securityHandler.setAuthenticator((Authenticator)KafkaRestApplications.this.restSecuritySetup.getAuthenticator());
            securityHandler.setLoginService(KafkaRestApplications.this.restSecuritySetup.getLoginService());
            securityHandler.setIdentityService(KafkaRestApplications.this.restSecuritySetup.getIdentityService());
            AuthUtil.createUnsecuredConstraints((RestConfig)KafkaRestApplications.this.restConfig).forEach(arg_0 -> ((ConstraintSecurityHandler)securityHandler).addConstraintMapping(arg_0));
            context.setSecurityHandler((SecurityHandler)securityHandler);
        }
    }
}

