/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.data.ScopedPermissions;
import io.confluent.controlcenter.license.LicenseInfo;
import io.confluent.controlcenter.license.LicenseManagerNotEnabledException;
import io.confluent.controlcenter.license.LicenseService;
import io.confluent.controlcenter.rest.req.UpdateLicenseRequest;
import io.confluent.controlcenter.rest.res.UpdateLicenseResponse;
import io.confluent.license.InvalidLicenseException;
import io.confluent.license.License;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;

@Path(value="/3.0/license")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LicenseResource {
    private final LicenseService licenseService;
    private final ControlCenterConfig controlCenterConfig;
    @Context
    private ScopedPermissions scopedPermissions;

    @Inject
    public LicenseResource(LicenseService licenseService, ControlCenterConfig controlCenterConfig) {
        this.licenseService = licenseService;
        this.controlCenterConfig = controlCenterConfig;
    }

    @GET
    public LicenseInfo licenseInfo() {
        if (!this.scopedPermissions.hasReadLicenseAccess()) {
            throw new ForbiddenException("user must have license read access");
        }
        return new LicenseInfo(this.licenseService.getCurrentLicense());
    }

    @GET
    @Path(value="/expiration")
    public long expiration() {
        return this.licenseService.getExpiration();
    }

    @GET
    @Path(value="/audience")
    public String audience() {
        return this.licenseService.getAudience();
    }

    @GET
    @Path(value="/payload")
    public String payload() {
        return this.licenseService.getPayload();
    }

    @GET
    @Path(value="/string")
    public String string() throws LicenseManagerNotEnabledException {
        if (!this.controlCenterConfig.getBoolean("confluent.controlcenter.license.manager.enable").booleanValue()) {
            throw new LicenseManagerNotEnabledException("License Manager is not enabled. ");
        }
        if (!this.scopedPermissions.isSuperUser()) {
            throw new ForbiddenException("user must have SystemAdmin access");
        }
        return this.licenseService.getString();
    }

    @POST
    @Path(value="/string:update")
    public UpdateLicenseResponse updateLicense(UpdateLicenseRequest updateLicenseRequest) throws InvalidLicenseException, LicenseManagerNotEnabledException, MalformedClaimException, InvalidJwtException {
        boolean updateSucceed;
        if (!this.controlCenterConfig.getBoolean("confluent.controlcenter.license.manager.enable").booleanValue()) {
            throw new LicenseManagerNotEnabledException("License Manager is not enabled. You cannot update license through REST request directly. You can apply your new license by updating properties file and restarting control center.");
        }
        if (!this.scopedPermissions.hasWriteLicenseAccess()) {
            throw new ForbiddenException("user must have license write access");
        }
        ArrayList<License> earlierLicenses = new ArrayList();
        try {
            earlierLicenses = new ArrayList<License>(this.licenseService.getLatestLicenses());
        }
        catch (InvalidLicenseException invalidLicenseException) {
            // empty catch block
        }
        List<License> updatedLicenses = this.licenseService.registerAndValidateLicense(updateLicenseRequest.getLicenseString());
        Optional<License> licenseOptional = updatedLicenses.stream().filter(license -> license.serializedForm().equals(updateLicenseRequest.getLicenseString())).findFirst();
        boolean bl = updateSucceed = licenseOptional.isPresent() && !this.areLicenseListsEqual(earlierLicenses, updatedLicenses);
        if (updateSucceed) {
            License matchingLicense = licenseOptional.get();
            License currentLicense = this.licenseService.getCurrentLicense();
            boolean inUse = currentLicense.serializedForm().equals(matchingLicense.serializedForm());
            return new UpdateLicenseResponse(true, new UpdateLicenseResponse.CurrentLicense(matchingLicense, inUse), "");
        }
        return new UpdateLicenseResponse(false, null, "Error updating the supplied License");
    }

    private boolean areLicenseListsEqual(List<License> list1, List<License> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        Set licenseStrings1 = list1.stream().map(License::serializedForm).collect(Collectors.toSet());
        Set licenseStrings2 = list2.stream().map(License::serializedForm).collect(Collectors.toSet());
        return licenseStrings1.equals(licenseStrings2);
    }
}

