/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.controlcenter.ControlCenterConfig;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.kafka.common.config.AbstractConfig;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifiableResource
extends Resource {
    private static final Logger log = LoggerFactory.getLogger(ModifiableResource.class);
    protected final Resource delegate;
    protected final ControlCenterConfig controlCenterConfig;

    public ModifiableResource(Resource delegate, ControlCenterConfig config) {
        Objects.requireNonNull(delegate);
        this.delegate = delegate;
        this.controlCenterConfig = config;
    }

    public boolean isContainedIn(Resource resource) throws MalformedURLException {
        return this.delegate.isContainedIn(resource);
    }

    public void close() {
        this.delegate.close();
    }

    public boolean exists() {
        return this.delegate.exists();
    }

    public boolean isDirectory() {
        return this.delegate.isDirectory();
    }

    public long lastModified() {
        return this.delegate.lastModified();
    }

    public long length() {
        return this.delegate.length();
    }

    public URL getURL() {
        return this.delegate.getURL();
    }

    public File getFile() throws IOException {
        return this.delegate.getFile();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return null;
    }

    public boolean delete() throws SecurityException {
        return this.delegate.delete();
    }

    public boolean renameTo(Resource resource) throws SecurityException {
        return this.delegate.renameTo(resource);
    }

    public String[] list() {
        return this.delegate.list();
    }

    public Resource addPath(String s) throws IOException, MalformedURLException {
        Resource resource = this.delegate.addPath(s);
        if (resource == null) {
            return null;
        }
        return this.isHtmlPageRequest(s) ? new HtmlResource(resource, this.controlCenterConfig) : resource;
    }

    private boolean isHtmlPageRequest(String name) {
        return "/index.html".equals(name);
    }

    static class HtmlResource
    extends ModifiableResource {
        public HtmlResource(Resource delegate, ControlCenterConfig config) {
            super(delegate, config);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.getResolvedHtml().getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public long length() {
            try {
                return this.getResolvedHtml().length();
            }
            catch (IOException e) {
                log.warn("Failed to get length of the HTML page resource", (Throwable)e);
                return 0L;
            }
        }

        private String getResolvedHtml() throws IOException {
            String origHtml = new BufferedReader(new InputStreamReader(this.delegate.getInputStream(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining(System.lineSeparator()));
            return (String)ObjectUtils.firstNonNull((Object[])new String[]{HtmlResource.getResolvedHtml(origHtml, this.controlCenterConfig), ""});
        }

        /*
         * Exception decompiling
         */
        @VisibleForTesting
        static String getResolvedHtml(String tokenizedHtml, AbstractConfig config) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static class HtmlPageData {
        String basePath;
        List<String> externalJsFiles;
        List<String> externalCssFiles;

        public HtmlPageData(String basePath, List<String> externalJsFiles, List<String> externalCssFiles) {
            this.basePath = basePath;
            this.externalJsFiles = externalJsFiles;
            this.externalCssFiles = externalCssFiles;
        }
    }
}

