/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.confluent.controlcenter.rest.ControlCenterRestModule;
import io.confluent.rest.RestConfig;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyRolesFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyRolesFilter.class);
    public static final Set<String> READ_METHODS = ImmutableSet.of((Object)"GET", (Object)"HEAD", (Object)"OPTIONS");
    private final Collection<String> roles;
    private final boolean enabled;

    @Inject
    ReadOnlyRolesFilter(RestConfig config, @ControlCenterRestModule.RestrictedRoles Collection<String> roles) {
        this.roles = roles;
        this.enabled = "BASIC".equals(config.getString("authentication.method"));
    }

    ReadOnlyRolesFilter(Collection<String> roles, boolean enabled) {
        this.roles = roles;
        this.enabled = enabled;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String httpMethod = ((HttpServletRequest)request).getMethod();
        if (this.enabled && !READ_METHODS.contains(httpMethod)) {
            for (String role : this.roles) {
                if (!((HttpServletRequest)request).isUserInRole(role)) continue;
                String user = ((HttpServletRequest)request).getUserPrincipal().getName();
                log.trace("user={} in role={}", (Object)user, (Object)role);
                ((HttpServletResponse)response).sendError(403, user + " only has read access");
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

