/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.inject.Inject;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.httpclient.HttpCredential;
import io.confluent.controlcenter.rest.AbstractClusterLookupProxyServlet;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClusterMetadata;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheck;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheckModule;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.client.api.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryProxyServlet
extends AbstractClusterLookupProxyServlet {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryProxyServlet.class);
    private static final String pathSpec = "/api/schema-registry/*";
    private final Random random = new Random();
    private final ControlCenterConfig controlCenterConfig;
    private final Map<String, HttpCredential> credentialsLookup;
    private final ServiceHealthCheck srHealthCheck;

    @Inject
    public SchemaRegistryProxyServlet(ControlCenterConfig controlCenterConfig, SchemaRegistryClusterMetadata srClusterMetadata, @ServiceHealthCheckModule.SchemaRegistryHealthCheck ServiceHealthCheck srHealthCheck) {
        this.controlCenterConfig = controlCenterConfig;
        this.credentialsLookup = srClusterMetadata.getCredentials();
        this.srHealthCheck = srHealthCheck;
    }

    protected void addProxyHeaders(HttpServletRequest clientRequest, Request proxyRequest) {
        super.addProxyHeaders(clientRequest, proxyRequest);
        this.maybeAddBasicAuthHeader(clientRequest, proxyRequest, this.credentialsLookup);
    }

    @Override
    public boolean enabled() {
        return this.controlCenterConfig.getBoolean("confluent.controlcenter.schema.registry.enable");
    }

    @Override
    public String getPathSpec() {
        return pathSpec;
    }

    @Override
    public String lookupEndpoint(String clusterId) {
        List<String> endpoints = this.srHealthCheck.getHealthyUrls(clusterId);
        if (endpoints == null) {
            return null;
        }
        if (endpoints.isEmpty()) {
            throw new RuntimeException("all nodes in SchemaRegistry cluster '" + clusterId + "' are down");
        }
        return endpoints.get(this.random.nextInt(endpoints.size()));
    }
}

