/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest;

import com.google.common.collect.ImmutableMap;
import io.confluent.controlcenter.errors.UpdateException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateExceptionMapper
implements ExceptionMapper<UpdateException> {
    private static final Logger log = LoggerFactory.getLogger(UpdateExceptionMapper.class);
    private static final Pattern INVALID_CLUSTER_NAME = Pattern.compile("Invalid ClusterInfo: (Cluster name\\s.*)");

    public Response toResponse(UpdateException exception) {
        String message;
        Matcher matcher;
        Throwable cause;
        Throwable throwable = cause = exception.getCause() != null ? exception.getCause() : exception;
        if (cause instanceof ConstraintViolationException && (matcher = INVALID_CLUSTER_NAME.matcher(message = ((ConstraintViolationException)cause).getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(",")))).matches()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(UpdateExceptionMapper.getError(matcher.group(1))).build();
        }
        log.error("Unhandled exception", cause);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(UpdateExceptionMapper.getError(cause.getMessage())).build();
    }

    static Map<Object, Object> getError(String message) {
        return ImmutableMap.of((Object)"error", (Object)ImmutableMap.of((Object)"nested_errors", (Object)ImmutableMap.of((Object)"displayName", (Object)message)));
    }
}

