/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.req;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.MoreObjects;
import io.confluent.controlcenter.rollup.Rollup;
import io.confluent.controlcenter.rollup.RollupFactory;
import io.confluent.monitoring.record.Monitoring;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RangeRequest {
    private static final Logger log = LoggerFactory.getLogger(RangeRequest.class);
    private long startTimeMs;
    private long stopTimeMs;
    public Rollup rollup = RollupFactory.getOneMinuteRollup();
    public String clusterId;
    public String clientId;
    public Monitoring.ClientType clientType;
    public String group;
    public Integer partition;
    public String topic;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeRequest that = (RangeRequest)o;
        return Objects.equals(this.clusterId, that.clusterId) && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientType, that.clientType) && Objects.equals(this.group, that.group) && Objects.equals(this.partition, that.partition) && Objects.equals(this.topic, that.topic);
    }

    public int hashCode() {
        return Objects.hash(this.clusterId, this.clientId, this.clientType, this.group, this.partition, this.topic);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clusterId", (Object)this.clusterId).add("clientId", (Object)this.clientId).add("clientType", (Object)this.clientType).add("group", (Object)this.group).add("partition", (Object)this.partition).add("topic", (Object)this.topic).toString();
    }

    private Monitoring.MonitoringMessage.Builder createBaseKeySpec() {
        Monitoring.MonitoringMessage.Builder builder = Monitoring.MonitoringMessage.newBuilder();
        builder.setClusterId(this.clusterId);
        if (this.clientId != null) {
            builder.setClientId(this.clientId);
        }
        if (this.clientType != null) {
            builder.setClientType(this.clientType);
        }
        if (this.group != null) {
            builder.setGroup(this.group);
        }
        if (this.topic != null) {
            builder.setTopic(this.topic);
        }
        if (this.partition != null) {
            builder.setPartition(this.partition.intValue());
        }
        return builder;
    }

    public Monitoring.MonitoringMessage createStartKeySpec() {
        Monitoring.MonitoringMessage.Builder builder = this.createBaseKeySpec();
        builder.setWindow(this.getRollupAlignedStartTimeMs());
        return builder.build();
    }

    public long getRollupAlignedStartTimeMs() {
        if (this.startTimeMs % this.rollup.getMillis() != 0L) {
            this.startTimeMs = this.startTimeMs / this.rollup.getMillis() * this.rollup.getMillis();
        }
        return this.startTimeMs;
    }

    public long getRollupAlignedStopTimeMs() {
        if (this.stopTimeMs % this.rollup.getMillis() != 0L) {
            this.stopTimeMs = this.stopTimeMs / this.rollup.getMillis() * this.rollup.getMillis();
        }
        return this.stopTimeMs;
    }

    public RangeRequest(String clusterId, long startTimeMs, long stopTimeMs) {
        this.clusterId = clusterId;
        this.startTimeMs = startTimeMs;
        this.stopTimeMs = stopTimeMs;
    }

    public RangeRequest(RangeRequest rangeRequest) {
        this.clusterId = rangeRequest.clusterId;
        this.startTimeMs = rangeRequest.startTimeMs;
        this.stopTimeMs = rangeRequest.stopTimeMs;
        this.rollup = rangeRequest.rollup;
        this.clientId = rangeRequest.clientId;
        this.clientType = rangeRequest.clientType;
        this.group = rangeRequest.group;
        this.partition = rangeRequest.partition;
        this.topic = rangeRequest.topic;
    }
}

