/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.res;

import io.confluent.controlcenter.rest.res.OmgDeserializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import javax.websocket.Session;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.errors.WakeupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumeToSocket
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ConsumeToSocket.class);
    private final OmgDeserializer deserializer;
    private final Consumer<byte[], byte[]> consumer;
    private final Session session;
    private long maxRecords;
    private boolean done = false;
    private final long maxMessageSize;

    public ConsumeToSocket(Session session, Consumer consumer, long maxRecords, long maxMessageSize, OmgDeserializer deserializer) {
        this.session = session;
        this.consumer = consumer;
        this.maxRecords = maxRecords;
        this.maxMessageSize = maxMessageSize;
        this.deserializer = deserializer != null ? deserializer : new OmgDeserializer(null);
    }

    @Override
    public void run() {
        try {
            if (!this.done && !Thread.currentThread().isInterrupted()) {
                log.debug("trace calling poll");
                ConsumerRecords records = this.consumer.poll(100L);
                Iterator iterator = records.iterator();
                while (iterator.hasNext() && this.maxRecords-- > 0L) {
                    ConsumerRecord record = (ConsumerRecord)iterator.next();
                    log.debug("trace got a record {}", (Object)record);
                    ConsumerRecord<Object, Object> message = (long)this.getRecordSize((ConsumerRecord<byte[], byte[]>)record) <= this.maxMessageSize ? this.decodeRecord((ConsumerRecord<byte[], byte[]>)record) : this.decodeRecord((ConsumerRecord<byte[], byte[]>)record, "__confluent_error", "Message too big to display");
                    this.session.getBasicRemote().sendObject(message);
                }
            }
            if (this.maxRecords <= 0L && this.session.isOpen()) {
                this.close();
            }
        }
        catch (WakeupException wakeup) {
            log.debug("waking up", (Throwable)wakeup);
        }
        catch (Throwable t) {
            log.warn("unable to consume", t);
            try {
                this.close();
            }
            catch (IOException e) {
                log.error("unable to close session", (Throwable)e);
            }
        }
    }

    private int getRecordSize(ConsumerRecord<byte[], byte[]> record) {
        return record.serializedKeySize() + record.serializedValueSize();
    }

    ConsumerRecord<Object, Object> decodeRecord(ConsumerRecord<byte[], byte[]> record) {
        return new ConsumerRecord(record.topic(), record.partition(), record.offset(), record.timestamp(), record.timestampType(), record.serializedKeySize(), record.serializedValueSize(), this.deserializer.deserializeKey(record), this.deserializer.deserializeValue(record), record.headers(), Optional.empty());
    }

    ConsumerRecord<Object, Object> decodeRecord(ConsumerRecord<byte[], byte[]> record, String key, String value) {
        return new ConsumerRecord(record.topic(), record.partition(), record.offset(), record.timestamp(), record.timestampType(), record.serializedKeySize(), record.serializedValueSize(), (Object)key, (Object)value, record.headers(), Optional.empty());
    }

    public void close() throws IOException {
        log.debug("closing session");
        this.done = true;
        this.session.close();
        this.consumer.close();
    }
}

