/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.res;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchemaUtils;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializer;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import javax.net.ssl.SSLException;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmgDeserializer {
    private static final Logger log = LoggerFactory.getLogger(OmgDeserializer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final StringDeserializer STRING_DESERIALIZER = new StringDeserializer();
    private static final boolean IS_KEY = true;
    private static final boolean IS_VALUE = false;
    private final KafkaAvroDeserializer avroKeyDeserializer;
    private final KafkaAvroDeserializer avroValueDeserializer;
    private final KafkaJsonSchemaDeserializer<JsonNode> jsonSchemaKeyDeserializer;
    private final KafkaJsonSchemaDeserializer<JsonNode> jsonSchemaValueDeserializer;
    private final KafkaProtobufDeserializer<Message> protobufKeyDeserializer;
    private final KafkaProtobufDeserializer<Message> protobufValueDeserializer;
    private final FormatMemoizingDeserializer keyDeserializer = new FormatMemoizingKeyDeserializer();
    private final FormatMemoizingDeserializer valueDeserializer = new FormatMemoizingValueDeserializer();

    public OmgDeserializer(SchemaRegistryClient schemaRegistryClient) {
        ImmutableMap configs = ImmutableMap.of((Object)"schema.registry.url", (Object)"dummy_url");
        this.avroKeyDeserializer = new KafkaAvroDeserializer(schemaRegistryClient);
        this.avroKeyDeserializer.configure((Map)configs, true);
        this.avroValueDeserializer = new KafkaAvroDeserializer(schemaRegistryClient);
        this.avroValueDeserializer.configure((Map)configs, false);
        this.jsonSchemaKeyDeserializer = new KafkaJsonSchemaDeserializer(schemaRegistryClient);
        this.jsonSchemaKeyDeserializer.configure((Map)configs, true);
        this.jsonSchemaValueDeserializer = new KafkaJsonSchemaDeserializer(schemaRegistryClient);
        this.jsonSchemaValueDeserializer.configure((Map)configs, false);
        this.protobufKeyDeserializer = new KafkaProtobufDeserializer(schemaRegistryClient);
        this.protobufKeyDeserializer.configure((Map)configs, true);
        this.protobufValueDeserializer = new KafkaProtobufDeserializer(schemaRegistryClient);
        this.protobufValueDeserializer.configure((Map)configs, false);
    }

    public Object deserializeKey(ConsumerRecord<byte[], byte[]> record) {
        return this.keyDeserializer.get(ConsumerRecord::key, record).apply(record);
    }

    public Object deserializeValue(ConsumerRecord<byte[], byte[]> record) {
        return this.valueDeserializer.get(ConsumerRecord::value, record).apply(record);
    }

    private Function<ConsumerRecord<byte[], byte[]>, Object> detect(boolean isKey, Function<ConsumerRecord<byte[], byte[]>, byte[]> selector, ConsumerRecord<byte[], byte[]> record) {
        byte[] bytes = selector.apply(record);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        Function<ConsumerRecord<byte[], byte[]>, Object> memoized = this.detectSchemaFormat(isKey, selector, record);
        if (memoized != null) {
            return memoized;
        }
        try {
            OmgDeserializer.fromJson(bytes);
            return ((Function<byte[], Object>)OmgDeserializer::fromJson).compose(selector);
        }
        catch (Exception e) {
            log.trace("unable to deserialize json", (Throwable)e);
            try {
                OmgDeserializer.fromString(bytes);
                return ((Function<byte[], Object>)OmgDeserializer::fromString).compose(selector);
            }
            catch (Exception e2) {
                log.trace("unable to deserialize string", (Throwable)e2);
                return ((Function<byte[], Object>)OmgDeserializer::objectCast).compose(selector);
            }
        }
    }

    protected Function<ConsumerRecord<byte[], byte[]>, Object> detectSchemaFormat(boolean isKey, Function<ConsumerRecord<byte[], byte[]>, byte[]> selector, ConsumerRecord<byte[], byte[]> record) {
        try {
            KafkaAvroDeserializer avroDeserializer = isKey ? this.avroKeyDeserializer : this.avroValueDeserializer;
            OmgDeserializer.fromAvro(avroDeserializer, selector, record);
            return r -> OmgDeserializer.fromAvro(avroDeserializer, selector, (ConsumerRecord<byte[], byte[]>)r);
        }
        catch (SerializationException e) {
            if (OmgDeserializer.isSubclassOf(e.getCause(), SSLException.class)) {
                log.error("unable to deserialize avro", (Throwable)e);
            } else {
                log.trace("unable to deserialize avro", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.trace("unable to deserialize avro", (Throwable)e);
        }
        try {
            KafkaJsonSchemaDeserializer<JsonNode> jsonSchemaDeserializer = isKey ? this.jsonSchemaKeyDeserializer : this.jsonSchemaValueDeserializer;
            OmgDeserializer.fromJsonSchema(jsonSchemaDeserializer, selector, record);
            return r -> OmgDeserializer.fromJsonSchema(jsonSchemaDeserializer, selector, (ConsumerRecord<byte[], byte[]>)r);
        }
        catch (SerializationException e) {
            if (OmgDeserializer.isSubclassOf(e.getCause(), SSLException.class)) {
                log.error("unable to deserialize json schema", (Throwable)e);
            } else {
                log.trace("unable to deserialize json schema", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.trace("unable to deserialize json schema", (Throwable)e);
        }
        try {
            KafkaProtobufDeserializer<Message> protobufDeserializer = isKey ? this.protobufKeyDeserializer : this.protobufValueDeserializer;
            OmgDeserializer.fromProtobuf(protobufDeserializer, selector, record);
            return r -> OmgDeserializer.fromProtobuf(protobufDeserializer, selector, (ConsumerRecord<byte[], byte[]>)r);
        }
        catch (SerializationException e) {
            if (OmgDeserializer.isSubclassOf(e.getCause(), SSLException.class)) {
                log.error("unable to deserialize protobuf", (Throwable)e);
            } else {
                log.trace("unable to deserialize protobuf", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.trace("unable to deserialize protobuf", (Throwable)e);
        }
        return null;
    }

    private static <T> Object objectCast(T value) {
        return value;
    }

    private static Object fromJson(byte[] bytes) {
        try {
            return OBJECT_MAPPER.readValue(bytes, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    private static String fromString(byte[] bytes) {
        return STRING_DESERIALIZER.deserialize(null, bytes);
    }

    private static Object fromAvro(KafkaAvroDeserializer avroDeserializer, Function<ConsumerRecord<byte[], byte[]>, byte[]> selector, ConsumerRecord<byte[], byte[]> record) {
        try {
            GenericRecord avroRecord = (GenericRecord)avroDeserializer.deserialize(record.topic(), selector.apply(record));
            byte[] bytes = AvroSchemaUtils.toJson((Object)avroRecord);
            return OmgDeserializer.fromJson(bytes);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    private static Object fromJsonSchema(KafkaJsonSchemaDeserializer<JsonNode> jsonSchemaDeserializer, Function<ConsumerRecord<byte[], byte[]>, byte[]> selector, ConsumerRecord<byte[], byte[]> record) {
        try {
            Object value = jsonSchemaDeserializer.deserialize(record.topic(), selector.apply(record));
            byte[] bytes = JsonSchemaUtils.toJson((Object)value);
            return OmgDeserializer.fromJson(bytes);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    private static Object fromProtobuf(KafkaProtobufDeserializer<Message> protobufDeserializer, Function<ConsumerRecord<byte[], byte[]>, byte[]> selector, ConsumerRecord<byte[], byte[]> record) {
        try {
            Message value = protobufDeserializer.deserialize(record.topic(), selector.apply(record));
            byte[] bytes = ProtobufSchemaUtils.toJson((Message)value);
            return OmgDeserializer.fromJson(bytes);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public static boolean isSubclassOf(Throwable e, Class<?> targetClass) {
        if (e == null || targetClass == null) {
            return false;
        }
        return targetClass.isAssignableFrom(e.getClass());
    }

    private abstract class FormatMemoizingDeserializer {
        boolean isKey;
        Function<ConsumerRecord<byte[], byte[]>, Object> memoized;

        private FormatMemoizingDeserializer() {
        }

        public Function<ConsumerRecord<byte[], byte[]>, Object> get(Function<ConsumerRecord<byte[], byte[]>, byte[]> selector, ConsumerRecord<byte[], byte[]> record) {
            if (this.memoized == null) {
                this.memoized = OmgDeserializer.this.detect(this.isKey, selector, (ConsumerRecord<byte[], byte[]>)record);
            }
            return this.memoized != null ? this.memoized : ((Function<byte[], Object>)x$0 -> OmgDeserializer.objectCast(x$0)).compose(selector);
        }
    }

    private class FormatMemoizingValueDeserializer
    extends FormatMemoizingDeserializer {
        FormatMemoizingValueDeserializer() {
            this.isKey = false;
        }
    }

    private class FormatMemoizingKeyDeserializer
    extends FormatMemoizingDeserializer {
        FormatMemoizingKeyDeserializer() {
            this.isKey = true;
        }
    }
}

