/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.res;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.controlcenter.rest.jackson.JsonStandard;
import io.confluent.controlcenter.rest.res.ReplicaStateResponse;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.QuorumInfo;

@JsonStandard
public class QuorumInfoResponse {
    @JsonProperty
    private final int leaderId;
    @JsonProperty
    private final List<ReplicaStateResponse> voters;
    @JsonProperty
    private final List<ReplicaStateResponse> observers;

    @JsonCreator
    public QuorumInfoResponse(@JsonProperty(value="leaderId") int leaderId, @JsonProperty(value="voters") List<ReplicaStateResponse> voters, @JsonProperty(value="observers") List<ReplicaStateResponse> observers) {
        this.leaderId = leaderId;
        this.voters = voters;
        this.observers = observers;
    }

    public QuorumInfoResponse(QuorumInfo quorumInfo) {
        this.leaderId = quorumInfo.leaderId();
        this.voters = quorumInfo.voters().stream().map(ReplicaStateResponse::new).collect(Collectors.toList());
        this.observers = quorumInfo.observers().stream().map(ReplicaStateResponse::new).collect(Collectors.toList());
    }

    public int getLeaderId() {
        return this.leaderId;
    }

    public List<ReplicaStateResponse> getVoters() {
        return this.voters;
    }

    public List<ReplicaStateResponse> getObservers() {
        return this.observers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuorumInfoResponse that = (QuorumInfoResponse)o;
        return this.leaderId == that.leaderId && Objects.equals(this.voters, that.voters) && Objects.equals(this.observers, that.observers);
    }

    public int hashCode() {
        return Objects.hash(this.leaderId, this.voters, this.observers);
    }
}

