/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.rest.res;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.confluent.controlcenter.rest.jackson.JsonStandard;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonStandard
public class ServiceHealth {
    private final List<String> all;
    private final List<String> healthy;
    private final List<String> unhealthy;

    public ServiceHealth(List<String> originalUrls, List<String> healthyUrls) {
        this.all = originalUrls;
        this.healthy = healthyUrls;
        this.unhealthy = ImmutableList.copyOf((Collection)Sets.difference((Set)ImmutableSet.copyOf(this.all), (Set)ImmutableSet.copyOf(this.healthy)));
    }

    public List<String> getAll() {
        return this.all;
    }

    public List<String> getHealthy() {
        return this.healthy;
    }

    public List<String> getUnhealthy() {
        return this.unhealthy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceHealth that = (ServiceHealth)o;
        return Objects.equals(this.all, that.all) && Objects.equals(this.healthy, that.healthy) && Objects.equals(this.unhealthy, that.unhealthy);
    }

    public int hashCode() {
        return Objects.hash(this.all, this.healthy, this.unhealthy);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("all", this.all).add("healthy", this.healthy).add("unhealthy", this.unhealthy).toString();
    }
}

