/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.schemaregistry;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.controlcenter.rest.Util;
import io.confluent.controlcenter.schemaregistry.SchemaRegistryClientSupplier;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingSchemaRegistryClientSupplier<K>
implements SchemaRegistryClientSupplier<K> {
    private static final Logger log = LoggerFactory.getLogger(CachingSchemaRegistryClientSupplier.class);
    private static final int DEFAULT_MAX_CACHE_SIZE = 100;
    private static final long DEFAULT_CACHE_EXPIRATION_MS = TimeUnit.MINUTES.toMillis(15L);
    private static final long CLEANUP_INTERVAL_MS = TimeUnit.MINUTES.toMillis(1L);
    private final LoadingCache<K, Optional<SchemaRegistryClient>> cache;
    private final ScheduledExecutorService exec = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("sr-client-cache-cleanup").setDaemon(true).build());

    public CachingSchemaRegistryClientSupplier(SchemaRegistryClientSupplier<K> baseSupplier) {
        this((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(DEFAULT_CACHE_EXPIRATION_MS, TimeUnit.MILLISECONDS), baseSupplier);
    }

    public CachingSchemaRegistryClientSupplier(CacheBuilder<Object, Object> cacheBuilder, final SchemaRegistryClientSupplier<K> baseSupplier) {
        this.cache = cacheBuilder.removalListener(notification -> {}).build(new CacheLoader<K, Optional<SchemaRegistryClient>>(){

            public Optional<SchemaRegistryClient> load(K key) {
                return Optional.ofNullable(baseSupplier.getClient(key));
            }
        });
        this.exec.scheduleAtFixedRate(this::cleanUp, CLEANUP_INTERVAL_MS, CLEANUP_INTERVAL_MS, TimeUnit.MILLISECONDS);
    }

    private void cleanUp() {
        List<TokenCredential> expiredTokens = Util.getExpiredTokens(this.cache.asMap().keySet());
        this.cache.invalidateAll(expiredTokens);
        if (!expiredTokens.isEmpty()) {
            log.info("Invalidated expired SR Client(s)");
        }
        this.cache.cleanUp();
    }

    @Override
    public SchemaRegistryClient getClient(K key) {
        try {
            Optional srClient = (Optional)this.cache.get(key);
            return srClient.orElse(null);
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee.getCause());
        }
    }

    public void invalidate(K key) {
        this.cache.invalidate(key);
    }
}

