/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.schemaregistry;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.ClusterMetadata;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.StaticClusterConfigSupplier;
import io.confluent.controlcenter.httpclient.HttpCredential;
import io.confluent.controlcenter.rest.ControlCenterRestModule;
import io.confluent.controlcenter.rest.res.SchemaRegistryCluster;
import io.confluent.controlcenter.util.ConfigUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SchemaRegistryClusterMetadata
extends ClusterMetadata<SchemaRegistryCluster> {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryClusterMetadata.class);
    private static final String AUTH_SOURCE_SUFFIX = "basic.auth.credentials.source";
    private String defaultName = "Default Schema Registry";
    private final Map<String, Map<String, Object>> configsLookup = new ConcurrentHashMap<String, Map<String, Object>>();
    private final Boolean isSrEnabled;

    @Inject
    public SchemaRegistryClusterMetadata(@ControlCenterRestModule.SchemaRegistryClusterConfigSupplier StaticClusterConfigSupplier srClusterConfigSupplier, ControlCenterConfig c3Config) {
        this.isSrEnabled = c3Config.getBoolean("confluent.controlcenter.schema.registry.enable");
        if (!this.isSrEnabled.booleanValue()) {
            return;
        }
        this.addClusters(srClusterConfigSupplier.getConfigurations());
        this.checkDefaultNameConflict();
        if (SchemaRegistryClusterMetadata.defaultSchemaRegistryEnabled(c3Config)) {
            this.addCluster((SchemaRegistryCluster)this.createCluster(this.defaultName, (Map)this.getDefaultSrConfig(c3Config)));
        } else {
            log.info("Schema Registry Cluster: {} is disabled", (Object)this.defaultName);
        }
    }

    private static boolean defaultSchemaRegistryEnabled(ControlCenterConfig c3Config) {
        Boolean srDisabled = c3Config.getBoolean("confluent.controlcenter.default.schema.registry.disable");
        return srDisabled == false;
    }

    @Override
    protected SchemaRegistryCluster createCluster(String displayName, Map<String, Object> config) {
        List<String> endpoints = ConfigUtils.getList(config, "url");
        if (this.checkInvalidEndpoints(endpoints)) {
            log.error("No valid endpoint urls specified for schema registry '{}'", (Object)displayName);
            return null;
        }
        String clusterId = this.createClusterId(endpoints);
        HttpCredential credential = this.createCredential(displayName, config);
        String authSource = (String)config.get(AUTH_SOURCE_SUFFIX);
        if (Strings.isNullOrEmpty((String)authSource) || !authSource.equals("USER_INFO")) {
            if (!Strings.isNullOrEmpty((String)authSource) && !authSource.equals("USER_INFO")) {
                log.error("{} is invalid, only USER_INFO is supported for Schema Registry {}", (Object)authSource, (Object)AUTH_SOURCE_SUFFIX);
            }
            credential = null;
        }
        return new SchemaRegistryCluster(clusterId, displayName, endpoints, credential, config);
    }

    @Override
    protected void addCluster(SchemaRegistryCluster cluster) {
        Preconditions.checkNotNull((Object)cluster);
        this.clusters.add(this.defaultName.equals(cluster.getDisplayName()) ? 0 : this.clusters.size(), cluster);
        this.endpointsLookup.put(cluster.getClusterId(), cluster.getEndpoints());
        if (cluster.getCredential() != null) {
            this.credentialsLookup.put(cluster.getClusterId(), cluster.getCredential());
        }
        this.configsLookup.put(cluster.getClusterId(), cluster.getConfig());
    }

    public Map<String, Map<String, Object>> getConfigs() {
        return this.configsLookup;
    }

    public Boolean isSrEnabled() {
        return this.isSrEnabled;
    }

    private void checkDefaultNameConflict() {
        Set clusterNames = this.clusters.stream().map(SchemaRegistryCluster::getDisplayName).collect(Collectors.toSet());
        int index = 2;
        while (clusterNames.contains(this.defaultName)) {
            String tag = String.format(" (%d)", index);
            this.defaultName = index > 2 ? this.defaultName.substring(0, this.defaultName.length() - tag.length()).concat(tag) : this.defaultName.concat(tag);
            ++index;
        }
    }

    private Map<String, Object> getDefaultSrConfig(ControlCenterConfig c3Config) {
        LinkedHashMap clusterConfigs = Maps.newLinkedHashMap();
        clusterConfigs.putAll(c3Config.originalsWithPrefix("confluent.controlcenter.schema.registry."));
        clusterConfigs.putAll(c3Config.valuesWithPrefix("confluent.controlcenter.schema.registry."));
        return clusterConfigs;
    }
}

