/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.serialization;

import com.google.inject.Binder;
import com.google.inject.BindingAnnotation;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.protobuf.Message;
import io.confluent.command.record.alert.CommandAlert;
import io.confluent.controlcenter.alert.record.Alert;
import io.confluent.controlcenter.keys.Keys;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.serialization.MonitoringVerifierSerde;
import io.confluent.controlcenter.serialization.OrderedKeyPrefixedClusterSerdeSupplier;
import io.confluent.controlcenter.serialization.OrderedKeyPrefixedMmSerdeSupplier;
import io.confluent.controlcenter.serialization.OrderedKeyPrefixedSerdeSupplier;
import io.confluent.controlcenter.streams.aggregation.MetricHolder;
import io.confluent.controlcenter.streams.aggregation.MetricValuesSerde;
import io.confluent.controlcenter.streams.verify.MonitoringVerifier;
import io.confluent.metrics.record.ConfluentMetric;
import io.confluent.monitoring.record.Monitoring;
import io.confluent.serializers.OrderedKeyProtoSerde;
import io.confluent.serializers.OrderedKeyUberSerde;
import io.confluent.serializers.OrderedKeyUberSerdeDelegate;
import io.confluent.serializers.ProtoSerde;
import io.confluent.serializers.StringSerde;
import io.confluent.serializers.UberSerde;
import io.confluent.serializers.UberSerdes;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;

public class SerializationModule
implements Module {
    public void configure(Binder binder) {
    }

    @Provides
    @Singleton
    private OrderedKeyPrefixedSerdeSupplier<Keys.KeyType, Monitoring.MonitoringMessage> keyTypeMonitoringMessageOrderedKeyPrefixedSerdeSupplier() {
        return new OrderedKeyPrefixedMmSerdeSupplier();
    }

    @Provides
    @Singleton
    private OrderedKeyPrefixedSerdeSupplier<Controlcenter.ClusterContext, Controlcenter.Cluster> clusterContextClusterOrderedKeyPrefixedSerdeSupplier() {
        return new OrderedKeyPrefixedClusterSerdeSupplier();
    }

    @Provides
    @Singleton
    private UberSerde<Controlcenter.ClientGroupProductionAggregate> clientGroupProductionAggregateSerde() {
        return new ProtoSerde((Message)Controlcenter.ClientGroupProductionAggregate.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<Monitoring.MonitoringMessage> monitoringMessageSerde() {
        return new ProtoSerde((Message)Monitoring.MonitoringMessage.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<ConfluentMetric.MetricsMessage> metricsMessageSerde() {
        return new ProtoSerde((Message)ConfluentMetric.MetricsMessage.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<MetricHolder> metricValuesSerde() {
        return UberSerdes.fromSerde((Serde)new MetricValuesSerde(), MetricHolder.class);
    }

    @Provides
    @Singleton
    private UberSerde<String> stringSerde() {
        return new StringSerde();
    }

    @Provides
    @Singleton
    private UberSerde<ByteBuffer> byteBufferSerde() {
        return UberSerdes.fromSerde((Serde)Serdes.ByteBuffer(), ByteBuffer.class);
    }

    @Provides
    @Singleton
    private UberSerde<Long> longSerde() {
        return UberSerdes.longs();
    }

    @Provides
    @Singleton
    private UberSerde<Controlcenter.TopicPartitionClientGroup> topicPartitionClientGroupSerde() {
        return new ProtoSerde((Message)Controlcenter.TopicPartitionClientGroup.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<Controlcenter.ClientGroup> clientGroupUberSerde() {
        return new ProtoSerde((Message)Controlcenter.ClientGroup.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<Controlcenter.ClientGroups> clientGroupsUberSerde() {
        return new ProtoSerde((Message)Controlcenter.ClientGroups.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<Controlcenter.TopicPartition> topicPartitionSerde() {
        return new ProtoSerde((Message)Controlcenter.TopicPartition.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<Controlcenter.TopicPartitionInfo> topicPartitionInfoSerde() {
        return new ProtoSerde((Message)Controlcenter.TopicPartitionInfo.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<Controlcenter.WindowedGrouping> windowedGroupingSerde() {
        return new ProtoSerde((Message)Controlcenter.WindowedGrouping.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<Controlcenter.Cluster> cluserSerde() {
        return new ProtoSerde((Message)Controlcenter.Cluster.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<Controlcenter.VerifiableMonitoringMessage> verifiableMonitoringMessageSerde() {
        return new ProtoSerde((Message)Controlcenter.VerifiableMonitoringMessage.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<MonitoringVerifier> monitoringVerifierSerde() {
        return new MonitoringVerifierSerde();
    }

    @Provides
    @Singleton
    private UberSerde<Controlcenter.TriggerMeasurement> triggerMeasurementSerde() {
        return new ProtoSerde((Message)Controlcenter.TriggerMeasurement.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<CommandAlert.MonitoringTriggerConfig> monitoringTriggerConfigUberSerde() {
        return new ProtoSerde((Message)CommandAlert.MonitoringTriggerConfig.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<CommandAlert.ActionConfig> actionConfigUberSerde() {
        return new ProtoSerde((Message)CommandAlert.ActionConfig.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<Controlcenter.WindowedClusterGroup> windowedClusterGroupSerde() {
        return new ProtoSerde((Message)Controlcenter.WindowedClusterGroup.getDefaultInstance());
    }

    @Provides
    @VerifierKeySerde
    @Singleton
    private OrderedKeyUberSerde<Monitoring.MonitoringMessage> getVerifierKeySerde() {
        return OrderedKeyProtoSerde.create((Message)Monitoring.MonitoringMessage.getDefaultInstance(), (int[])new int[]{22, 1, 3, 2, 8, 9, 4});
    }

    @Provides
    @MonitoringTriggerKeySerde
    @Singleton
    private OrderedKeyUberSerde<Controlcenter.WindowedClusterGroup> getMonitoringTriggerKeySerde() {
        return OrderedKeyProtoSerde.create((Message)Controlcenter.WindowedClusterGroup.getDefaultInstance(), (int[])new int[]{2, 3, 4, 1});
    }

    @Provides
    @TriggerActionsKeySerde
    @Singleton
    private OrderedKeyUberSerde<Controlcenter.TriggerEventKey> getTriggerActionsKeySerde() {
        return OrderedKeyProtoSerde.create((Message)Controlcenter.TriggerEventKey.getDefaultInstance(), (int[])new int[]{1, 4, 2, 3});
    }

    @Provides
    @TriggerEventsKeySerde
    @Singleton
    private OrderedKeyUberSerde<Alert.AlertInfo> getTriggerEventsKeySerde() {
        return new AlertInfoInvertedTimestampSerde((OrderedKeyUberSerde<Alert.AlertInfo>)OrderedKeyProtoSerde.create((Message)Alert.AlertInfo.getDefaultInstance(), (int[])new int[]{2, 1}));
    }

    @Provides
    @TriggerEventsKeyPrefixSerde
    @Singleton
    private OrderedKeyUberSerde<Alert.AlertInfo> getTriggerEventsKeyPrefixSerde(@TriggerEventsKeySerde OrderedKeyUberSerde<Alert.AlertInfo> keySerde) {
        return new AlertInfoInvertedTimestampSerde((OrderedKeyUberSerde<Alert.AlertInfo>)OrderedKeyProtoSerde.create((Message)Alert.AlertInfo.getDefaultInstance(), (int[])new int[]{2, 1}));
    }

    @Provides
    @Singleton
    private UberSerde<Controlcenter.TriggerActions> triggerActionsSerde() {
        return new ProtoSerde((Message)Controlcenter.TriggerActions.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<Controlcenter.VerifiableTriggerInfo> verifiableTriggerSerde() {
        return new ProtoSerde((Message)Controlcenter.VerifiableTriggerInfo.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<Alert.AlertInfo> alertInfoSerde() {
        return new ProtoSerde((Message)Alert.AlertInfo.getDefaultInstance());
    }

    @Provides
    @Singleton
    private UberSerde<Controlcenter.TriggerEvent> triggerEventSerde() {
        return new ProtoSerde((Message)Controlcenter.TriggerEvent.getDefaultInstance());
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface TriggerEventsKeyPrefixSerde {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface TriggerEventsKeySerde {
    }

    static class AlertInfoInvertedTimestampSerde
    extends OrderedKeyUberSerdeDelegate<Alert.AlertInfo> {
        AlertInfoInvertedTimestampSerde(OrderedKeyUberSerde<Alert.AlertInfo> delegate) {
            super(delegate);
        }

        public Bytes key(Alert.AlertInfo message) {
            return super.key((Object)Alert.AlertInfo.newBuilder((Alert.AlertInfo)message).setTimestamp(-message.getTimestamp()).build());
        }

        public Alert.AlertInfo toProto(Bytes key) {
            Alert.AlertInfo ai = (Alert.AlertInfo)super.toProto(key);
            return Alert.AlertInfo.newBuilder((Alert.AlertInfo)ai).setTimestamp(-ai.getTimestamp()).build();
        }
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface TriggerActionsKeySerde {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface MonitoringTriggerKeySerde {
    }

    @BindingAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    public static @interface VerifierKeySerde {
    }
}

