/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.serialization.formatter;

import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.serialization.formatter.UberFormatter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvUberFormatter
extends UberFormatter {
    private static final Logger log = LoggerFactory.getLogger(CsvUberFormatter.class);
    private String[] header;
    private CSVPrinter printer = null;

    public CsvUberFormatter(ControlCenterConfig config, String topic) {
        super(config, topic, log);
    }

    @Override
    public void configure(Map<String, ?> configs) {
        super.configure(configs);
        this.header = this.getHeader();
    }

    @Override
    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        if (this.printer == null) {
            log.error("CSVPrinter is not set yet: must use setPrinter() before writeTo().");
            return;
        }
        super.writeTo(consumerRecord, output);
    }

    @Override
    public void doWriteTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        try {
            if (this.printTopic) {
                this.printer.print((Object)consumerRecord.topic());
            }
            if (this.printPartition) {
                this.printer.print((Object)Integer.toString(consumerRecord.partition()));
            }
            if (this.printTs) {
                this.printer.print((Object)new DateTime(consumerRecord.timestamp()).toString());
            }
            if (this.printKey) {
                this.printer.print((Object)this.getKeyString(consumerRecord.topic(), (byte[])consumerRecord.key()));
            }
            this.printer.print((Object)this.getValueString(consumerRecord.topic(), (byte[])consumerRecord.value()));
            this.printer.println();
        }
        catch (IOException ex) {
            log.error("Failed to write a record in csv format: " + ex);
        }
    }

    public void setPrinter(PrintStream ps, boolean withHeader) throws IOException {
        this.printer = withHeader ? new CSVPrinter((Appendable)ps, CSVFormat.DEFAULT.withHeader(this.header)) : new CSVPrinter((Appendable)ps, CSVFormat.DEFAULT);
    }

    private String[] getHeader() {
        ArrayList<String> header = new ArrayList<String>();
        if (this.printTopic) {
            header.add("topic");
        }
        if (this.printPartition) {
            header.add("partition");
        }
        if (this.printTs) {
            header.add("timestamp");
        }
        if (this.printKey) {
            header.add("key");
        }
        header.add("value");
        return header.toArray(new String[0]);
    }
}

