/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.serialization.formatter;

import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.serialization.formatter.UberFormatter;
import java.io.PrintStream;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUberFormatter
extends UberFormatter {
    private static final Logger log = LoggerFactory.getLogger(JsonUberFormatter.class);
    private static final String fieldSeparator = "\t";
    private static final String lineSeparator = "\n";

    public JsonUberFormatter() {
        super(new ControlCenterConfig(), null, log);
    }

    public JsonUberFormatter(ControlCenterConfig config, String topic) {
        super(config, topic, log);
    }

    @Override
    public void doWriteTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        if (this.printTopic) {
            output.append(consumerRecord.topic());
            output.append(fieldSeparator);
        }
        if (this.printPartition) {
            output.append(Integer.toString(consumerRecord.partition()));
            output.append(fieldSeparator);
        }
        if (this.printTs) {
            output.append(new DateTime(consumerRecord.timestamp()).toString());
            output.append(fieldSeparator);
        }
        if (this.printKey) {
            output.append(this.getKeyString(consumerRecord.topic(), (byte[])consumerRecord.key()));
            output.append(fieldSeparator);
        }
        output.append(this.getValueString(consumerRecord.topic(), (byte[])consumerRecord.value()));
        output.append(lineSeparator);
    }
}

