/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.serialization.formatter;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Injector;
import io.confluent.controlcenter.BootstrapClientSupplier;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.KafkaHelper;
import io.confluent.controlcenter.serialization.WindowStoreSerde;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.util.InjectorFactory;
import io.confluent.serializers.SerdeWithJson;
import io.confluent.serializers.UberSerde;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.errors.SerializationException;
import org.slf4j.Logger;

public abstract class UberFormatter
implements MessageFormatter {
    private final Logger log;
    private final ControlCenterConfig config;
    private Injector injector;
    private String topic;
    private boolean allowErrors;
    private TopicStoreMaster topicStoreMaster;
    private TopicStoreMaster.SerdePair serdesPair;
    private boolean isNonUserDefinedTopic;
    boolean printTopic;
    boolean printPartition;
    boolean printTs;
    boolean printKey;

    public UberFormatter(ControlCenterConfig config, String topic, Logger log) {
        this.config = config;
        this.topic = topic;
        this.log = log;
    }

    abstract void doWriteTo(ConsumerRecord<byte[], byte[]> var1, PrintStream var2);

    public void configure(Map<String, ?> configs) {
        try {
            this.injector = InjectorFactory.createInjectorForScripts(this.config);
            this.topicStoreMaster = (TopicStoreMaster)this.injector.getInstance(TopicStoreMaster.class);
            this.allowErrors = this.getBoolean(configs, "allow.errors");
            this.printTopic = this.getBoolean(configs, "print.topic");
            this.printPartition = this.getBoolean(configs, "print.partition");
            this.printTs = this.getBoolean(configs, "print.timestamp");
            this.printKey = this.getBoolean(configs, "print.key");
            if (this.topic != null) {
                this.checkTopicExists();
                this.checkSerdesForTopic(this.topic);
            }
        }
        catch (Exception e) {
            this.log.error("Init failed: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        if (this.topic == null) {
            this.topic = consumerRecord.topic();
            this.checkSerdesForTopic(consumerRecord.topic());
        }
        this.checkTopicMatching(consumerRecord.topic());
        this.doWriteTo(consumerRecord, output);
    }

    public void close() {
    }

    public void checkTopicExists() throws Exception {
        BootstrapClientSupplier bootstrapClientSupplier = (BootstrapClientSupplier)this.injector.getInstance(BootstrapClientSupplier.class);
        KafkaHelper kafkaHelper = new KafkaHelper(bootstrapClientSupplier.get());
        if (!kafkaHelper.getTopics().contains(this.topic)) {
            throw new RuntimeException("Topic \"" + this.topic + "\" does not exist in the cluster");
        }
    }

    private void checkSerdesForTopic(String topic) throws SerializationException {
        this.serdesPair = this.topicStoreMaster.getSerdesForTopic(topic);
        this.isNonUserDefinedTopic = this.isNonUserDefinedTopic(topic);
        if (this.isNonUserDefinedTopic && this.serdesPair == null && !this.allowErrors) {
            throw new SerializationException("No serde found for topic: " + topic);
        }
    }

    private void checkTopicMatching(String topic) {
        if (!topic.equals(this.topic)) {
            throw new RuntimeException("topic didn't match the expected \"" + this.topic + "\"");
        }
    }

    private boolean isNonUserDefinedTopic(String topic) {
        return this.topicStoreMaster.getInputTopicNames().contains((Object)topic) || this.topicStoreMaster.getInternalTopicNames().contains((Object)topic);
    }

    private boolean getBoolean(Map<String, ?> configs, String name) {
        if (configs.containsKey(name)) {
            return Boolean.parseBoolean(this.getString(configs, name).trim());
        }
        return true;
    }

    String getValueString(String topic, byte[] valueBytes) {
        UberSerde serde = null;
        if (this.serdesPair != null) {
            serde = this.serdesPair.valueSerde;
        }
        return this.getString(topic, valueBytes, (SerdeWithJson)serde, "value");
    }

    String getKeyString(String topic, byte[] keyBytes) {
        WindowStoreSerde serde = null;
        if (this.serdesPair != null) {
            serde = this.serdesPair.windowedSerde != null ? this.serdesPair.windowedSerde : this.serdesPair.keySerde;
        }
        return this.getString(topic, keyBytes, serde, "key");
    }

    private String getString(Map<String, ?> configs, String name) {
        Object o = configs.get(name);
        if (o instanceof String) {
            return (String)o;
        }
        if (o == null) {
            return null;
        }
        throw new IllegalArgumentException("Unexpected type for config value for '" + name + "', expected String but found " + o.getClass() + ", value: " + o);
    }

    private String getString(String topic, byte[] bytes, SerdeWithJson serde, String errField) {
        if (bytes == null) {
            return "null";
        }
        if (!this.isNonUserDefinedTopic && serde == null) {
            return new String(bytes, StandardCharsets.UTF_8);
        }
        if (serde == null) {
            if (this.allowErrors) {
                return "ERROR: No serde found";
            }
            throw new SerializationException("No " + errField + " serde found for topic: " + topic);
        }
        try {
            return serde.toJson(serde.deserialize(bytes));
        }
        catch (SerializationException e) {
            if (this.allowErrors) {
                return "ERROR: " + e.getMessage();
            }
            throw e;
        }
    }

    @VisibleForTesting
    public void setTopic(String topic) {
        this.topic = topic;
    }
}

