/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.servicehealthcheck;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientFactoryBuilder;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroup;
import com.linecorp.armeria.client.endpoint.healthcheck.HealthCheckedEndpointGroupBuilder;
import com.linecorp.armeria.client.logging.LoggingClient;
import com.linecorp.armeria.client.logging.LoggingClientBuilder;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.SessionProtocol;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.httpclient.HttpCredential;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheck;
import io.confluent.controlcenter.ssl.SslHolder;
import io.confluent.controlcenter.ssl.SslUtils;
import io.confluent.controlcenter.util.UriUtils;
import io.confluent.rest.RestConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArmeriaServiceHealthCheck
implements ServiceHealthCheck {
    private static final Logger log = LoggerFactory.getLogger(ServiceHealthCheck.class);
    private static final Duration CONNECT_TIMEOUT = Duration.ofSeconds(15L);
    private final Map<String, List<String>> originalUrls;
    private final Map<String, HealthCheckedEndpointGroup> healthCheckMap = new HashMap<String, HealthCheckedEndpointGroup>();
    private final Map<String, UrlsHttpsEnabled> healthyUrlsMap = new ConcurrentHashMap<String, UrlsHttpsEnabled>();
    private final Duration healthCheckInterval;
    private final String healthCheckPath;
    private final RestConfig restConfig;
    private final SslHolder serverSslHolder;
    private final List<SslHolder> proxySslHolders;
    private final ControlCenterConfig controlCenterConfig;
    private final Function<String, HttpCredential> credentialSupplier;

    public ArmeriaServiceHealthCheck(Duration healthCheckInterval, Map<String, List<String>> clusterUrlMap, String healthCheckPath, RestConfig restConfig, ControlCenterConfig controlCenterConfig, SslHolder serverSslHolder, List<SslHolder> proxySslHolders, Function<String, HttpCredential> credentialSupplier) {
        this.healthCheckInterval = healthCheckInterval;
        this.healthCheckPath = healthCheckPath;
        this.restConfig = restConfig;
        this.controlCenterConfig = controlCenterConfig;
        this.serverSslHolder = serverSslHolder;
        this.proxySslHolders = proxySslHolders;
        this.credentialSupplier = credentialSupplier;
        ImmutableMap.Builder origBuilder = ImmutableMap.builder();
        for (Map.Entry<String, List<String>> cluster : clusterUrlMap.entrySet()) {
            String clusterNameOrId = cluster.getKey();
            UrlsHttpsEnabled urls = new UrlsHttpsEnabled(ArmeriaServiceHealthCheck.normalizeUrls(cluster.getValue()));
            origBuilder.put((Object)clusterNameOrId, (Object)ImmutableList.copyOf(urls.getUrls()));
            String urlPath = this.extractPath(urls);
            HealthCheckedEndpointGroup healthCheck = this.createHealthCheck(clusterNameOrId, urls.getUrls(), urls.isHttpsEnabled(), urlPath);
            healthCheck.addListener(endpoints -> this.updateHealthyNodes(clusterNameOrId, (List<Endpoint>)endpoints, urlPath));
            this.healthCheckMap.put(clusterNameOrId, healthCheck);
            this.healthyUrlsMap.put(clusterNameOrId, urls);
        }
        this.originalUrls = origBuilder.build();
    }

    public String extractPath(UrlsHttpsEnabled urls) {
        List extraPath = urls.getUrls().stream().map(ArmeriaServiceHealthCheck::stringToUri).map(URI::getPath).distinct().collect(Collectors.toList());
        if (extraPath.size() == 1) {
            return (String)extraPath.get(0);
        }
        return "";
    }

    @Override
    public List<String> getHealthyUrls(String clusterId) {
        UrlsHttpsEnabled urls = this.healthyUrlsMap.get(clusterId);
        if (urls == null) {
            return null;
        }
        return urls.getUrls();
    }

    @Override
    public void markUnhealthy(String clusterId, String url) {
        UrlsHttpsEnabled urls = this.healthyUrlsMap.get(clusterId);
        if (urls != null) {
            urls.removeUrl(ArmeriaServiceHealthCheck.normalizeUrl(url));
        }
    }

    @Override
    public List<String> getOriginalUrls(String clusterId) {
        return this.originalUrls.get(clusterId);
    }

    @Override
    public void close() {
        for (HealthCheckedEndpointGroup healthCheck : this.healthCheckMap.values()) {
            healthCheck.close();
        }
    }

    private HealthCheckedEndpointGroup createHealthCheck(String clusterNameOrId, List<String> urls, boolean httpsEnabled, String urlPath) {
        List endpoints = urls.stream().map(ArmeriaServiceHealthCheck::stringToUri).map(ArmeriaServiceHealthCheck::uriToEndpoint).collect(Collectors.toList());
        ClientFactoryBuilder clientFactory = ClientFactory.builder().tlsCustomizer(ssl -> SslUtils.NettySslUtils.buildNettySslContext(ssl, this.restConfig, this.serverSslHolder, this.proxySslHolders, this.controlCenterConfig)).connectTimeout(CONNECT_TIMEOUT);
        ClientOptionsBuilder options = ClientOptions.builder();
        LoggingClientBuilder loggingClientBuilder = LoggingClient.builder().headersSanitizer((ctx, headers) -> {
            HttpHeadersBuilder builder = headers.toBuilder();
            if (builder.contains((CharSequence)HttpHeader.AUTHORIZATION.asString())) {
                builder.set((CharSequence)HttpHeader.AUTHORIZATION.asString(), "xxxxxxxx");
            }
            return builder.build();
        });
        options.decorator(loggingClientBuilder.newDecorator());
        HttpCredential httpCredential = this.credentialSupplier.apply(clusterNameOrId);
        if (httpCredential != null) {
            options.setHeader((CharSequence)HttpHeader.AUTHORIZATION.toString(), (Object)httpCredential.authorizationHeaderValue());
        }
        String fullHealthcheckPath = urlPath != null ? urlPath + this.healthCheckPath : this.healthCheckPath;
        return ((HealthCheckedEndpointGroupBuilder)((HealthCheckedEndpointGroupBuilder)((HealthCheckedEndpointGroupBuilder)((HealthCheckedEndpointGroupBuilder)HealthCheckedEndpointGroup.builder((EndpointGroup)EndpointGroup.of(endpoints), (String)fullHealthcheckPath).useGet(true).clientFactory(clientFactory.build())).clientOptions(options.build())).protocol(this.controlCenterConfig.getBoolean("confluent.controlcenter.armeria.healthcheck.force.http1").booleanValue() ? (httpsEnabled ? SessionProtocol.H1 : SessionProtocol.H1C) : (httpsEnabled ? SessionProtocol.HTTPS : SessionProtocol.HTTP))).retryInterval(this.healthCheckInterval)).build();
    }

    private void updateHealthyNodes(String clusterId, List<Endpoint> endpoints, String urlPath) {
        this.healthyUrlsMap.compute(clusterId, (k, v) -> {
            Preconditions.checkNotNull((Object)v);
            return new UrlsHttpsEnabled(endpoints.stream().map(e -> ArmeriaServiceHealthCheck.endpointToString(e, v.isHttpsEnabled())).map(url -> url + urlPath).collect(Collectors.toList()), v.isHttpsEnabled());
        });
    }

    private static boolean httpsEnabled(List<String> urls) {
        for (String url : urls) {
            if (!url.toLowerCase().startsWith("https://")) continue;
            return true;
        }
        return false;
    }

    private static String endpointToString(Endpoint endpoint, boolean https) {
        return "http" + (https ? "s" : "") + "://" + endpoint.host() + ":" + endpoint.port();
    }

    private static Endpoint uriToEndpoint(URI uri) {
        return Endpoint.of((String)uri.getHost(), (int)(uri.getPort() > 0 ? uri.getPort() : 80));
    }

    private static URI stringToUri(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException e) {
            log.error("unable to parse url {}", (Object)url, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private static List<String> normalizeUrls(List<String> urls) {
        return urls.stream().map(ArmeriaServiceHealthCheck::normalizeUrl).collect(Collectors.toList());
    }

    private static String normalizeUrl(String url) {
        try {
            return UriUtils.uriWithDefaultScheme(url, "http").toString();
        }
        catch (URISyntaxException e) {
            log.error("unable to parse url {}", (Object)url, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private static class UrlsHttpsEnabled {
        private final List<String> urls;
        private final boolean httpsEnabled;

        UrlsHttpsEnabled(List<String> urls) {
            this(urls, ArmeriaServiceHealthCheck.httpsEnabled(urls));
        }

        UrlsHttpsEnabled(List<String> urls, boolean httpsEnabled) {
            this.urls = new ArrayList<String>((Collection<String>)ImmutableList.copyOf(urls));
            this.httpsEnabled = httpsEnabled;
        }

        boolean isHttpsEnabled() {
            return this.httpsEnabled;
        }

        List<String> getUrls() {
            return this.urls;
        }

        void removeUrl(String url) {
            this.urls.remove(url);
        }
    }
}

