/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.ssl;

import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.rest.RestConfig;
import io.confluent.rest.SslConfig;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslHolder {
    private static final Logger log = LoggerFactory.getLogger(SslHolder.class);
    private final KeyManagerFactory keyManagerFactory;
    private final TrustManagerFactory trustManagerFactory;
    private final Map<String, List<String>> clientAliasesToHosts;

    public SslHolder(String prefix, ControlCenterConfig controlCenterConfig, Map<String, List<String>> clientAliasesToHosts) {
        this(SslHolder.getSslConfig(prefix, controlCenterConfig), clientAliasesToHosts);
    }

    public SslHolder(SslConfig sslConfig, Map<String, List<String>> clientAliasesToHosts) {
        this.keyManagerFactory = SslHolder.createKeyManagerFactory(sslConfig);
        this.trustManagerFactory = SslHolder.createTrustManagerFactory(sslConfig);
        this.clientAliasesToHosts = clientAliasesToHosts;
    }

    private static SslConfig getSslConfig(String prefix, ControlCenterConfig controlCenterConfig) {
        RestConfig restConfig = new RestConfig(RestConfig.baseConfigDef(), controlCenterConfig.originalsWithPrefix(prefix));
        return restConfig.getBaseSslConfig();
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    private static KeyManagerFactory createKeyManagerFactory(SslConfig sslConfig) {
        try {
            if (!sslConfig.getKeyStorePath().isEmpty()) {
                KeyManagerFactory kmf = !sslConfig.getKeyManagerFactoryAlgorithm().isEmpty() ? KeyManagerFactory.getInstance(sslConfig.getKeyManagerFactoryAlgorithm()) : KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore keyStore = KeyStore.getInstance(sslConfig.getKeyStoreType());
                keyStore.load(Files.newInputStream(Paths.get(sslConfig.getKeyStorePath(), new String[0]), new OpenOption[0]), sslConfig.getKeyStorePassword().isEmpty() ? null : sslConfig.getKeyStorePassword().toCharArray());
                kmf.init(keyStore, sslConfig.getKeyManagerPassword().toCharArray());
                return kmf;
            }
        }
        catch (Exception e) {
            log.error("Error initializing client keystore", (Throwable)e);
            throw new RuntimeException(e);
        }
        return null;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    private static TrustManagerFactory createTrustManagerFactory(SslConfig sslConfig) {
        try {
            if (!sslConfig.getTrustStorePath().isEmpty()) {
                TrustManagerFactory tmf = !sslConfig.getTrustManagerFactoryAlgorithm().isEmpty() ? TrustManagerFactory.getInstance(sslConfig.getTrustManagerFactoryAlgorithm()) : TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore trustStore = KeyStore.getInstance(sslConfig.getTrustStoreType());
                trustStore.load(Files.newInputStream(Paths.get(sslConfig.getTrustStorePath(), new String[0]), new OpenOption[0]), sslConfig.getTrustStorePassword().isEmpty() ? null : sslConfig.getTrustStorePassword().toCharArray());
                tmf.init(trustStore);
                return tmf;
            }
        }
        catch (Exception e) {
            log.error("Error initializing client truststore", (Throwable)e);
            throw new RuntimeException(e);
        }
        return null;
    }

    public Map<String, List<String>> getClientAliasesToHosts() {
        return this.clientAliasesToHosts;
    }
}

