/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams;

import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.streams.aggregation.GroupBy;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.BranchedKStream;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.KGroupedStream;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.Printed;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.Repartitioned;
import org.apache.kafka.streams.kstream.StreamJoined;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.ValueJoinerWithKey;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueMapperWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.TopicNameExtractor;
import org.apache.kafka.streams.processor.api.FixedKeyProcessorSupplier;
import org.apache.kafka.streams.state.KeyValueStore;

public class C3Stream<K, V>
implements KStream<K, V> {
    final KStream<K, V> delegate;
    final StreamsBuilder builder;

    public C3Stream(KStream<K, V> delegate, StreamsBuilder builder) {
        this.delegate = delegate;
        this.builder = builder;
    }

    public <K2, V2> C3Stream<K2, V2> wrap(KStream<K2, V2> toWrap) {
        return new C3Stream<K2, V2>(toWrap, this.builder);
    }

    public <K2, V2> C3Stream<K2, V2>[] wrap(KStream<K2, V2>[] toWrap) {
        C3Stream[] arr = new C3Stream[toWrap.length];
        for (int i = 0; i < toWrap.length; ++i) {
            arr[i] = this.wrap(toWrap[i]);
        }
        return arr;
    }

    public C3Stream<K, V> filter(Predicate<? super K, ? super V> predicate) {
        return this.wrap(this.delegate.filter(predicate));
    }

    public C3Stream<K, V> filter(Predicate<? super K, ? super V> predicate, Named named) {
        return this.wrap(this.delegate.filter(predicate, named));
    }

    public C3Stream<K, V> filterNot(Predicate<? super K, ? super V> predicate) {
        return this.wrap(this.delegate.filterNot(predicate));
    }

    public C3Stream<K, V> filterNot(Predicate<? super K, ? super V> predicate, Named named) {
        return this.wrap(this.delegate.filterNot(predicate, named));
    }

    public <K1> C3Stream<K1, V> selectKey(KeyValueMapper<? super K, ? super V, ? extends K1> mapper) {
        return this.wrap(this.delegate.selectKey(mapper));
    }

    public <KR> C3Stream<KR, V> selectKey(KeyValueMapper<? super K, ? super V, ? extends KR> keyValueMapper, Named named) {
        return this.wrap(this.delegate.selectKey(keyValueMapper, named));
    }

    public <K1, V1> C3Stream<K1, V1> map(KeyValueMapper<? super K, ? super V, ? extends KeyValue<? extends K1, ? extends V1>> mapper) {
        return this.wrap(this.delegate.map(mapper));
    }

    public <KR, VR> C3Stream<KR, VR> map(KeyValueMapper<? super K, ? super V, ? extends KeyValue<? extends KR, ? extends VR>> keyValueMapper, Named named) {
        return this.wrap(this.delegate.map(keyValueMapper, named));
    }

    public <V1> C3Stream<K, V1> mapValues(ValueMapper<? super V, ? extends V1> mapper) {
        return this.wrap(this.delegate.mapValues(mapper));
    }

    public <VR> C3Stream<K, VR> mapValues(ValueMapper<? super V, ? extends VR> valueMapper, Named named) {
        return this.wrap(this.delegate.mapValues(valueMapper, named));
    }

    public <V1> C3Stream<K, V1> mapValues(ValueMapperWithKey<? super K, ? super V, ? extends V1> mapper) {
        return this.wrap(this.delegate.mapValues(mapper));
    }

    public <VR> C3Stream<K, VR> mapValues(ValueMapperWithKey<? super K, ? super V, ? extends VR> valueMapperWithKey, Named named) {
        return this.wrap(this.delegate.mapValues(valueMapperWithKey, named));
    }

    public void print(Printed<K, V> printed) {
        this.delegate.print(printed);
    }

    public C3Stream<K, V> merge(KStream<K, V> stream) {
        return this.wrap(this.delegate.merge(stream));
    }

    public C3Stream<K, V> merge(KStream<K, V> stream, Named named) {
        return this.wrap(this.delegate.merge(stream, named));
    }

    public <K1, V1> C3Stream<K1, V1> flatMap(KeyValueMapper<? super K, ? super V, ? extends Iterable<? extends KeyValue<? extends K1, ? extends V1>>> mapper) {
        return this.wrap(this.delegate.flatMap(mapper));
    }

    public <KR, VR> C3Stream<KR, VR> flatMap(KeyValueMapper<? super K, ? super V, ? extends Iterable<? extends KeyValue<? extends KR, ? extends VR>>> keyValueMapper, Named named) {
        return this.wrap(this.delegate.flatMap(keyValueMapper, named));
    }

    public <V1> C3Stream<K, V1> flatMapValues(ValueMapper<? super V, ? extends Iterable<? extends V1>> processor) {
        return this.wrap(this.delegate.flatMapValues(processor));
    }

    public <VR> C3Stream<K, VR> flatMapValues(ValueMapper<? super V, ? extends Iterable<? extends VR>> valueMapper, Named named) {
        return this.wrap(this.delegate.flatMapValues(valueMapper, named));
    }

    public <V1> C3Stream<K, V1> flatMapValues(ValueMapperWithKey<? super K, ? super V, ? extends Iterable<? extends V1>> processor) {
        return this.wrap(this.delegate.flatMapValues(processor));
    }

    public <VR> C3Stream<K, VR> flatMapValues(ValueMapperWithKey<? super K, ? super V, ? extends Iterable<? extends VR>> valueMapperWithKey, Named named) {
        return this.wrap(this.delegate.flatMapValues(valueMapperWithKey, named));
    }

    public C3Stream<K, V>[] branch(Predicate<? super K, ? super V> ... predicates) {
        return this.wrap(this.delegate.branch(predicates));
    }

    public C3Stream<K, V>[] branch(Named named, Predicate<? super K, ? super V> ... predicates) {
        return this.wrap(this.delegate.branch(named, predicates));
    }

    public BranchedKStream<K, V> split() {
        return this.delegate.split();
    }

    public BranchedKStream<K, V> split(Named named) {
        return this.delegate.split(named);
    }

    public void foreach(ForeachAction<? super K, ? super V> action) {
        this.delegate.foreach(action);
    }

    public void foreach(ForeachAction<? super K, ? super V> foreachAction, Named named) {
        this.delegate.foreach(foreachAction, named);
    }

    public C3Stream<K, V> through(String topic) {
        return this.wrap(this.delegate.through(topic));
    }

    public <K1, T1> C3Stream<K, V> through(TopicStoreMaster.Topic<K, V, K1, T1> topic) {
        this.to(topic);
        return this.wrap(this.builder.stream(topic.name, Consumed.with(topic.keySerde, topic.valueSerde)));
    }

    public <K2, T2> C3Stream<K, V> through(StreamPartitioner<? super K, ? super V> partitioner, TopicStoreMaster.Topic<K, V, K2, T2> topic) {
        this.to(topic.name, Produced.with(topic.keySerde, topic.valueSerde, partitioner));
        return this.wrap(this.builder.stream(topic.name, Consumed.with(topic.keySerde, topic.valueSerde)));
    }

    public KStream<K, V> through(String topic, Produced<K, V> produced) {
        return this.wrap(this.delegate.through(topic, produced));
    }

    public <K1, T1> void to(TopicStoreMaster.Topic<K, V, K1, T1> topic) {
        this.delegate.to(topic.name, Produced.with(topic.keySerde, topic.valueSerde));
    }

    public void to(String topic) {
        this.delegate.to(topic);
    }

    public void to(String topic, Produced<K, V> produced) {
        this.delegate.to(topic, produced);
    }

    public void to(TopicNameExtractor<K, V> topicExtractor) {
        this.delegate.to(topicExtractor);
    }

    public void to(TopicNameExtractor<K, V> topicExtractor, Produced<K, V> produced) {
        this.delegate.to(topicExtractor, produced);
    }

    public KTable<K, V> toTable() {
        return this.delegate.toTable();
    }

    public KTable<K, V> toTable(Named named) {
        return this.delegate.toTable(named);
    }

    public KTable<K, V> toTable(Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        return this.delegate.toTable(materialized);
    }

    public KTable<K, V> toTable(Named named, Materialized<K, V, KeyValueStore<Bytes, byte[]>> materialized) {
        return this.delegate.toTable(named, materialized);
    }

    public <K1, V1> C3Stream<K1, V1> transform(TransformerSupplier<? super K, ? super V, KeyValue<K1, V1>> transformerSupplier, String ... stateStoreNames) {
        return this.wrap(this.delegate.transform(transformerSupplier, stateStoreNames));
    }

    public <K1, V1> C3Stream<K1, V1> transform(TransformerSupplier<? super K, ? super V, KeyValue<K1, V1>> transformerSupplier, Named named, String ... strings) {
        return this.wrap(this.delegate.transform(transformerSupplier, named, strings));
    }

    public <K1, V1> C3Stream<K1, V1> flatTransform(TransformerSupplier<? super K, ? super V, Iterable<KeyValue<K1, V1>>> transformerSupplier, String ... stateStoreNames) {
        return this.wrap(this.delegate.flatTransform(transformerSupplier, stateStoreNames));
    }

    public <K1, V1> C3Stream<K1, V1> flatTransform(TransformerSupplier<? super K, ? super V, Iterable<KeyValue<K1, V1>>> transformerSupplier, Named named, String ... strings) {
        return this.wrap(this.delegate.flatTransform(transformerSupplier, named, strings));
    }

    public <R> KStream<K, R> flatTransformValues(ValueTransformerSupplier<? super V, Iterable<R>> valueTransformerSupplier, String ... stateStoreNames) {
        return this.wrap(this.delegate.flatTransformValues(valueTransformerSupplier, stateStoreNames));
    }

    public <VR> C3Stream<K, VR> flatTransformValues(ValueTransformerSupplier<? super V, Iterable<VR>> valueTransformerSupplier, Named named, String ... strings) {
        return this.wrap(this.delegate.flatTransformValues(valueTransformerSupplier, named, strings));
    }

    public <R> C3Stream<K, R> flatTransformValues(ValueTransformerWithKeySupplier<? super K, ? super V, Iterable<R>> valueTransformerSupplier, String ... stateStoreNames) {
        return this.wrap(this.delegate.flatTransformValues(valueTransformerSupplier, stateStoreNames));
    }

    public <VR> C3Stream<K, VR> flatTransformValues(ValueTransformerWithKeySupplier<? super K, ? super V, Iterable<VR>> valueTransformerWithKeySupplier, Named named, String ... strings) {
        return this.wrap(this.delegate.flatTransformValues(valueTransformerWithKeySupplier, named, strings));
    }

    public <R> C3Stream<K, R> transformValues(ValueTransformerSupplier<? super V, ? extends R> valueTransformerSupplier, String ... stateStoreNames) {
        return this.wrap(this.delegate.transformValues(valueTransformerSupplier, stateStoreNames));
    }

    public <VR> C3Stream<K, VR> transformValues(ValueTransformerSupplier<? super V, ? extends VR> valueTransformerSupplier, Named named, String ... strings) {
        return this.wrap(this.delegate.transformValues(valueTransformerSupplier, named, strings));
    }

    public <R> C3Stream<K, R> transformValues(ValueTransformerWithKeySupplier<? super K, ? super V, ? extends R> valueTransformerSupplier, String ... stateStoreNames) {
        return this.wrap(this.delegate.transformValues(valueTransformerSupplier, stateStoreNames));
    }

    public <VR> C3Stream<K, VR> transformValues(ValueTransformerWithKeySupplier<? super K, ? super V, ? extends VR> valueTransformerWithKeySupplier, Named named, String ... strings) {
        return this.wrap(this.delegate.transformValues(valueTransformerWithKeySupplier, named, strings));
    }

    public void process(ProcessorSupplier<? super K, ? super V> processorSupplier, String ... stateStoreNames) {
        this.delegate.process(processorSupplier, stateStoreNames);
    }

    public void process(ProcessorSupplier<? super K, ? super V> processorSupplier, Named named, String ... strings) {
        this.delegate.process(processorSupplier, named, strings);
    }

    public <KOut, VOut> KStream<KOut, VOut> process(org.apache.kafka.streams.processor.api.ProcessorSupplier<? super K, ? super V, KOut, VOut> processorSupplier, String ... stateStoreNames) {
        return this.delegate.process(processorSupplier, stateStoreNames);
    }

    public <KOut, VOut> KStream<KOut, VOut> process(org.apache.kafka.streams.processor.api.ProcessorSupplier<? super K, ? super V, KOut, VOut> processorSupplier, Named named, String ... stateStoreNames) {
        return this.delegate.process(processorSupplier, named, stateStoreNames);
    }

    public <VOut> KStream<K, VOut> processValues(FixedKeyProcessorSupplier<? super K, ? super V, VOut> fixedKeyProcessorSupplier, String ... stateStoreNames) {
        return this.delegate.processValues(fixedKeyProcessorSupplier, stateStoreNames);
    }

    public <VOut> KStream<K, VOut> processValues(FixedKeyProcessorSupplier<? super K, ? super V, VOut> fixedKeyProcessorSupplier, Named named, String ... stateStoreNames) {
        return this.delegate.processValues(fixedKeyProcessorSupplier, named, stateStoreNames);
    }

    public <K1, V1, V2> C3Stream<K, V2> join(GlobalKTable<K1, V1> globalKTable, KeyValueMapper<? super K, ? super V, ? extends K1> keyValueMapper, ValueJoiner<? super V, ? super V1, ? extends V2> joiner) {
        return this.wrap(this.delegate.join(globalKTable, keyValueMapper, joiner));
    }

    public <GK, GV, RV> C3Stream<K, RV> join(GlobalKTable<GK, GV> globalKTable, KeyValueMapper<? super K, ? super V, ? extends GK> keyValueMapper, ValueJoinerWithKey<? super K, ? super V, ? super GV, ? extends RV> valueJoinerWithKey) {
        return this.wrap(this.delegate.join(globalKTable, keyValueMapper, valueJoinerWithKey));
    }

    public <GK, GV, RV> C3Stream<K, RV> join(GlobalKTable<GK, GV> globalKTable, KeyValueMapper<? super K, ? super V, ? extends GK> keyValueMapper, ValueJoiner<? super V, ? super GV, ? extends RV> valueJoiner, Named named) {
        return this.wrap(this.delegate.join(globalKTable, keyValueMapper, valueJoiner, named));
    }

    public <GK, GV, RV> C3Stream<K, RV> join(GlobalKTable<GK, GV> globalKTable, KeyValueMapper<? super K, ? super V, ? extends GK> keyValueMapper, ValueJoinerWithKey<? super K, ? super V, ? super GV, ? extends RV> valueJoinerWithKey, Named named) {
        return this.wrap(this.delegate.join(globalKTable, keyValueMapper, valueJoinerWithKey, named));
    }

    public <V1, R> C3Stream<K, R> join(KStream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, ? extends R> joiner, JoinWindows windows) {
        return this.wrap(this.delegate.join(otherStream, joiner, windows));
    }

    public <V1, R> C3Stream<K, R> join(KStream<K, V1> otherStream, ValueJoinerWithKey<? super K, ? super V, ? super V1, ? extends R> valueJoinerWithKey, JoinWindows windows) {
        return this.wrap(this.delegate.join(otherStream, valueJoinerWithKey, windows));
    }

    public <V1, R> KStream<K, R> join(KStream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, ? extends R> joiner, JoinWindows windows, StreamJoined<K, V, V1> joined) {
        return this.wrap(this.delegate.join(otherStream, joiner, windows, joined));
    }

    public <V1, V2> KStream<K, V2> join(KTable<K, V1> table, ValueJoiner<? super V, ? super V1, ? extends V2> valueJoiner) {
        return this.wrap(this.delegate.join(table, valueJoiner));
    }

    public <V1, V2> C3Stream<K, V2> join(KTable<K, V1> table, ValueJoinerWithKey<? super K, ? super V, ? super V1, ? extends V2> valueJoinerWithKey) {
        return this.wrap(this.delegate.join(table, valueJoinerWithKey));
    }

    public <V1, V2> KStream<K, V2> join(KTable<K, V1> table, ValueJoiner<? super V, ? super V1, ? extends V2> joiner, Joined<K, V, V1> joined) {
        return this.wrap(this.delegate.join(table, joiner, joined));
    }

    public <V1, V2> C3Stream<K, V2> join(KTable<K, V1> table, ValueJoinerWithKey<? super K, ? super V, ? super V1, ? extends V2> valueJoinerWithKey, Joined<K, V, V1> joined) {
        return this.wrap(this.delegate.join(table, valueJoinerWithKey, joined));
    }

    public <VO, VR> C3Stream<K, VR> join(KStream<K, VO> otherStream, ValueJoinerWithKey<? super K, ? super V, ? super VO, ? extends VR> valueJoinerWithKey, JoinWindows joinWindows, StreamJoined<K, V, VO> streamJoined) {
        return this.wrap(this.delegate.join(otherStream, valueJoinerWithKey, joinWindows, streamJoined));
    }

    public <V1, R> C3Stream<K, R> outerJoin(C3Stream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, R> joiner, JoinWindows windows, StreamJoined<K, V, V1> joined) {
        return this.wrap(this.delegate.outerJoin(otherStream.delegate, joiner, windows, joined));
    }

    public <V1, R> C3Stream<K, R> outerJoin(KStream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, ? extends R> joiner, JoinWindows windows) {
        return this.wrap(this.delegate.outerJoin(otherStream, joiner, windows));
    }

    public <V1, R> C3Stream<K, R> outerJoin(KStream<K, V1> otherStream, ValueJoinerWithKey<? super K, ? super V, ? super V1, ? extends R> valueJoinerWithKey, JoinWindows windows) {
        return this.wrap(this.delegate.outerJoin(otherStream, valueJoinerWithKey, windows));
    }

    public <VO, VR> KStream<K, VR> outerJoin(KStream<K, VO> otherStream, ValueJoiner<? super V, ? super VO, ? extends VR> valueJoiner, JoinWindows joinWindows, StreamJoined<K, V, VO> streamJoined) {
        return this.delegate.outerJoin(otherStream, valueJoiner, joinWindows, streamJoined);
    }

    public <VO, VR> C3Stream<K, VR> outerJoin(KStream<K, VO> otherStream, ValueJoinerWithKey<? super K, ? super V, ? super VO, ? extends VR> valueJoinerWithKey, JoinWindows joinWindows, StreamJoined<K, V, VO> streamJoined) {
        return this.wrap(this.delegate.outerJoin(otherStream, valueJoinerWithKey, joinWindows, streamJoined));
    }

    public <VO, VR> KStream<K, VR> leftJoin(KStream<K, VO> otherStream, ValueJoiner<? super V, ? super VO, ? extends VR> valueJoiner, JoinWindows joinWindows, StreamJoined<K, V, VO> streamJoined) {
        return this.delegate.leftJoin(otherStream, valueJoiner, joinWindows, streamJoined);
    }

    public <K1, V1, V2> KStream<K, V2> leftJoin(GlobalKTable<K1, V1> globalKTable, KeyValueMapper<? super K, ? super V, ? extends K1> keyValueMapper, ValueJoiner<? super V, ? super V1, ? extends V2> valueJoiner) {
        return this.delegate.leftJoin(globalKTable, keyValueMapper, valueJoiner);
    }

    public <K1, V1, V2> C3Stream<K, V2> leftJoin(GlobalKTable<K1, V1> globalKTable, KeyValueMapper<? super K, ? super V, ? extends K1> keyValueMapper, ValueJoinerWithKey<? super K, ? super V, ? super V1, ? extends V2> valueJoinerWithKey) {
        return this.wrap(this.delegate.leftJoin(globalKTable, keyValueMapper, valueJoinerWithKey));
    }

    public <GK, GV, RV> C3Stream<K, RV> leftJoin(GlobalKTable<GK, GV> globalKTable, KeyValueMapper<? super K, ? super V, ? extends GK> keyValueMapper, ValueJoiner<? super V, ? super GV, ? extends RV> valueJoiner, Named named) {
        return this.wrap(this.delegate.leftJoin(globalKTable, keyValueMapper, valueJoiner, named));
    }

    public <GK, GV, RV> C3Stream<K, RV> leftJoin(GlobalKTable<GK, GV> globalKTable, KeyValueMapper<? super K, ? super V, ? extends GK> keyValueMapper, ValueJoinerWithKey<? super K, ? super V, ? super GV, ? extends RV> valueJoinerWithKey, Named named) {
        return this.wrap(this.delegate.leftJoin(globalKTable, keyValueMapper, valueJoinerWithKey, named));
    }

    public <V1, R> C3Stream<K, R> leftJoin(C3Stream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, R> joiner, JoinWindows windows) {
        return this.wrap(this.delegate.leftJoin(otherStream.delegate, joiner, windows));
    }

    public <V1, R> C3Stream<K, R> leftJoin(KStream<K, V1> otherStream, ValueJoiner<? super V, ? super V1, ? extends R> joiner, JoinWindows windows) {
        return this.wrap(this.delegate.leftJoin(otherStream, joiner, windows));
    }

    public <V1, R> C3Stream<K, R> leftJoin(KStream<K, V1> otherStream, ValueJoinerWithKey<? super K, ? super V, ? super V1, ? extends R> joiner, JoinWindows windows) {
        return this.wrap(this.delegate.leftJoin(otherStream, joiner, windows));
    }

    public <V1, R> C3Stream<K, R> leftJoin(KStream<K, V1> otherStream, ValueJoinerWithKey<? super K, ? super V, ? super V1, ? extends R> joiner, JoinWindows windows, StreamJoined<K, V, V1> streamJoined) {
        return this.wrap(this.delegate.leftJoin(otherStream, joiner, windows, streamJoined));
    }

    public <V1, V2> C3Stream<K, V2> leftJoin(KTable<K, V1> table, ValueJoiner<? super V, ? super V1, ? extends V2> joiner) {
        return this.wrap(this.delegate.leftJoin(table, joiner));
    }

    public <V1, V2> C3Stream<K, V2> leftJoin(KTable<K, V1> table, ValueJoinerWithKey<? super K, ? super V, ? super V1, ? extends V2> valueJoinerWithKey) {
        return this.wrap(this.delegate.leftJoin(table, valueJoinerWithKey));
    }

    public <V1, V2> KStream<K, V2> leftJoin(KTable<K, V1> table, ValueJoiner<? super V, ? super V1, ? extends V2> joiner, Joined<K, V, V1> joined) {
        return this.wrap(this.delegate.leftJoin(table, joiner, joined));
    }

    public <VT, V2> C3Stream<K, V2> leftJoin(KTable<K, VT> table, ValueJoinerWithKey<? super K, ? super V, ? super VT, ? extends V2> valueJoinerWithKey, Joined<K, V, VT> joined) {
        return this.wrap(this.delegate.leftJoin(table, valueJoinerWithKey, joined));
    }

    public <K1> KGroupedStream<K1, V> groupBy(KeyValueMapper<? super K, ? super V, K1> selector) {
        return this.delegate.groupBy(selector);
    }

    public <K1> KGroupedStream<K1, V> groupBy(KeyValueMapper<? super K, ? super V, K1> selector, Grouped<K1, V> grouped) {
        return this.delegate.groupBy(selector, grouped);
    }

    public <K1> KGroupedStream<K1, V> groupBy(GroupBy<? super K, K1> groupBy, Serde<V> valSerde) {
        return this.flatMap(groupBy.keyValueMapper()).groupByKey(Grouped.with(groupBy.keySerde(), valSerde));
    }

    public <K1> KGroupedStream<K1, V> groupBy(GroupBy<? super K, K1> groupBy, TopicStoreMaster.Topic<?, V, ?, ?> throughTopic) {
        return this.flatMap(groupBy.keyValueMapper()).through(throughTopic.name, Produced.with(groupBy.keySerde(), throughTopic.valueSerde, groupBy.streamPartitioner())).groupByKey(Grouped.with(groupBy.keySerde(), throughTopic.valueSerde));
    }

    public KGroupedStream<K, V> groupByKey() {
        return this.delegate.groupByKey();
    }

    public KGroupedStream<K, V> groupByKey(Grouped<K, V> grouped) {
        return this.delegate.groupByKey(grouped);
    }

    public C3Stream<K, V> peek(ForeachAction<? super K, ? super V> foreachAction) {
        return this.wrap(this.delegate.peek(foreachAction));
    }

    public C3Stream<K, V> peek(ForeachAction<? super K, ? super V> foreachAction, Named named) {
        return this.wrap(this.delegate.peek(foreachAction, named));
    }

    public C3Stream<K, V> repartition() {
        return this.wrap(this.delegate.repartition());
    }

    public C3Stream<K, V> repartition(Repartitioned<K, V> repartitioned) {
        return this.wrap(this.delegate.repartition(repartitioned));
    }
}

