/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams;

import com.google.common.base.Preconditions;
import io.confluent.controlcenter.streams.C3Stream;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.streams.WindowExtractor;
import java.util.Set;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.state.StoreBuilder;

public class C3Streams {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends StreamsBuilder {
        public Builder withStoreBuilders(Set<StoreBuilder> storeSuppliers) {
            for (StoreBuilder sb : storeSuppliers) {
                this.addStateStore(sb);
            }
            return this;
        }

        public <K, V, K1, V1> C3Stream<K, V> stream(TopicStoreMaster.Topic<K, V, K1, V1> topic) {
            return new C3Stream(this.stream(topic.name, Consumed.with(topic.keySerde, topic.valueSerde, (TimestampExtractor)new WindowExtractor(), (Topology.AutoOffsetReset)Topology.AutoOffsetReset.EARLIEST)), this);
        }

        public <K, V> C3Stream<K, V> merge(C3Stream<K, V> s1, C3Stream<K, V> s2) {
            return this.mergeStreams(s1, s2);
        }

        public <K, V> C3Stream<K, V> merge(C3Stream<K, V> s1, C3Stream<K, V> s2, C3Stream<K, V> s3) {
            return this.mergeStreams(s1, s2, s3);
        }

        public <K, V> C3Stream<K, V> merge(C3Stream<K, V> s1, C3Stream<K, V> s2, C3Stream<K, V> s3, C3Stream<K, V> s4) {
            return this.mergeStreams(s1, s2, s3, s4);
        }

        public <K, V> C3Stream<K, V> merge(C3Stream<K, V> s1, C3Stream<K, V> s2, C3Stream<K, V> s3, C3Stream<K, V> s4, C3Stream<K, V> s5, C3Stream<K, V> ... others) {
            C3Stream[] streams = new C3Stream[5 + others.length];
            streams[0] = s1;
            streams[1] = s2;
            streams[2] = s3;
            streams[3] = s4;
            streams[4] = s5;
            System.arraycopy(others, 0, streams, 5, others.length);
            return this.mergeStreams(streams);
        }

        <K, V> C3Stream<K, V> mergeStreams(C3Stream ... c3Streams) {
            Preconditions.checkNotNull((Object)c3Streams);
            Preconditions.checkArgument((c3Streams.length > 0 ? 1 : 0) != 0);
            KStream output = new C3Stream(c3Streams[0], this);
            for (int i = 1; i < c3Streams.length; ++i) {
                KStream underlying = c3Streams[i].delegate;
                output = output.merge(underlying);
            }
            return output;
        }
    }
}

