/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams;

import com.google.common.collect.Maps;
import io.confluent.common.Configurable;
import io.confluent.controlcenter.ControlCenterBoundedMemoryConfig;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.streams.state.RocksDBConfigSetter;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.Cache;
import org.rocksdb.LRUCache;
import org.rocksdb.Options;
import org.rocksdb.Statistics;
import org.rocksdb.WriteBufferManager;

public class RocksDBConfigurator
implements RocksDBConfigSetter,
Configurable {
    public static final Map<String, Map<String, Options>> APP_INSTANCES = Maps.newConcurrentMap();
    private static Cache cache;
    private static WriteBufferManager writeBufferManager;
    private static final AtomicBoolean configured;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Map<String, ?> configs) {
        AtomicBoolean atomicBoolean = configured;
        synchronized (atomicBoolean) {
            if (!configured.getAndSet(true)) {
                this.initMemoryLimits(new ControlCenterBoundedMemoryConfig(configs));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(String storeName, Options options, Map<String, Object> configs) {
        ControlCenterBoundedMemoryConfig memoryConfig = new ControlCenterBoundedMemoryConfig(configs);
        if (memoryConfig.getBoolean("rocksdb.cache.size.limit.enabled").booleanValue()) {
            this.configure(configs);
            RocksDBConfigurator.limitTotalMemory(cache, writeBufferManager, options);
        }
        String appId = configs.get("application.id").toString();
        Map<String, Map<String, Options>> map = APP_INSTANCES;
        synchronized (map) {
            TreeMap optionsMap = APP_INSTANCES.get(appId);
            if (optionsMap == null) {
                optionsMap = Maps.newTreeMap();
                APP_INSTANCES.put(appId, optionsMap);
            }
            if (options.statistics() == null) {
                Statistics statistics = new Statistics();
                options = options.setStatistics(statistics);
            }
            optionsMap.put(storeName, options);
        }
    }

    public void close(String storeName, Options options) {
    }

    private void initMemoryLimits(ControlCenterBoundedMemoryConfig config) {
        cache = new LRUCache(config.getLong("rocksdb.cache.size").longValue(), -1, config.getBoolean("rocksdb.cache.limit.strict").booleanValue(), config.getDouble("rocksdb.index.filter.block.ratio").doubleValue());
        writeBufferManager = config.getBoolean("rocksdb.write.buffer.cache.use") != false ? new WriteBufferManager(config.getLong("rocksdb.write.buffer.size").longValue(), cache) : new WriteBufferManager(config.getLong("rocksdb.write.buffer.size").longValue(), (Cache)new LRUCache(config.getLong("rocksdb.write.buffer.size").longValue(), -1, config.getBoolean("rocksdb.cache.limit.strict").booleanValue(), config.getDouble("rocksdb.index.filter.block.ratio").doubleValue()));
    }

    private static void limitTotalMemory(Cache cache, WriteBufferManager writeBufferManager, Options options) {
        BlockBasedTableConfig tableConfig = (BlockBasedTableConfig)options.tableFormatConfig();
        tableConfig.setBlockCache(cache);
        tableConfig.setCacheIndexAndFilterBlocks(true);
        options.setWriteBufferManager(writeBufferManager);
        tableConfig.setCacheIndexAndFilterBlocksWithHighPriority(true);
        tableConfig.setPinTopLevelIndexAndFilter(true);
    }

    static {
        configured = new AtomicBoolean(false);
    }
}

