/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams;

import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.confluent.command.cluster_metadata.CommandClusterMetadata;
import io.confluent.command.record.Command;
import io.confluent.controlcenter.ControlCenterModule;
import io.confluent.controlcenter.alert.AlertSenderRouter;
import io.confluent.controlcenter.alert.record.Alert;
import io.confluent.controlcenter.command.CommandModule;
import io.confluent.controlcenter.data.KafkaMetadataDao;
import io.confluent.controlcenter.keys.Keys;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.rest.TokenCredential;
import io.confluent.controlcenter.rollup.Rollup;
import io.confluent.controlcenter.rollup.RollupFactory;
import io.confluent.controlcenter.serialization.OrderedKeyPrefixedSerdeSupplier;
import io.confluent.controlcenter.streams.BroadcastHeartbeatTransformerSupplier;
import io.confluent.controlcenter.streams.C3Stream;
import io.confluent.controlcenter.streams.C3Streams;
import io.confluent.controlcenter.streams.Identity;
import io.confluent.controlcenter.streams.InjectMonitoringPartitionTransformer;
import io.confluent.controlcenter.streams.KafkaClusterMetadataToCommandMapper;
import io.confluent.controlcenter.streams.Predicates;
import io.confluent.controlcenter.streams.StreamsModule;
import io.confluent.controlcenter.streams.TopicStoreMaster;
import io.confluent.controlcenter.streams.TopicStoreModule;
import io.confluent.controlcenter.streams.TransformCompositeMetrics;
import io.confluent.controlcenter.streams.aggregation.MetricEvent;
import io.confluent.controlcenter.streams.aggregation.MetricHolder;
import io.confluent.controlcenter.streams.aggregation.MetricValues;
import io.confluent.controlcenter.streams.aggregation.MetricsAggregation;
import io.confluent.controlcenter.streams.aggregation.MetricsExtractor;
import io.confluent.controlcenter.streams.alert.AlertHistoryProcessorSupplier;
import io.confluent.controlcenter.streams.alert.AlertTransformerSupplier;
import io.confluent.controlcenter.streams.alert.GroupMeasurement;
import io.confluent.controlcenter.streams.alert.MetricToTriggerMeasurementTransformerSupplier;
import io.confluent.controlcenter.streams.alert.MonitoringTriggerMeasurementJoiner;
import io.confluent.controlcenter.streams.alert.MonitoringTriggerTransformerSupplier;
import io.confluent.controlcenter.streams.alert.TriggerEventStreamsUtil;
import io.confluent.controlcenter.streams.consumergroups.ConsumerGroupStreamExtension;
import io.confluent.controlcenter.streams.group.GroupStreamExtension;
import io.confluent.controlcenter.streams.monitoring.MonitoringPredicates;
import io.confluent.controlcenter.streams.monitoring.MonitoringStreamExtension;
import io.confluent.controlcenter.streams.verify.MonitoringVerifier;
import io.confluent.controlcenter.streams.verify.VerifyTransformerSupplier;
import io.confluent.controlcenter.util.versions.BrokerVersion;
import io.confluent.controlcenter.util.versions.KafkaVersionTracker;
import io.confluent.metrics.record.ConfluentMetric;
import io.confluent.monitoring.common.MonitoringMessageUtil;
import io.confluent.monitoring.record.Monitoring;
import io.confluent.serializers.OrderedKeyPrefixedSerde;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.ForeachAction;
import org.apache.kafka.streams.kstream.JoinWindows;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.StreamJoined;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.kstream.TransformerSupplier;
import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.ValueTransformer;
import org.apache.kafka.streams.kstream.ValueTransformerSupplier;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.state.StoreBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamBuilderProvider
implements Provider<C3Streams.Builder> {
    private static final Logger log = LoggerFactory.getLogger(StreamBuilderProvider.class);
    private static final StreamPartitioner<Bytes, Controlcenter.TriggerEvent> TRIGGER_EVENT_PARTITIONER = new StreamPartitioner<Bytes, Controlcenter.TriggerEvent>(){

        public Integer partition(String topic, Bytes key, Controlcenter.TriggerEvent value, int numPartitions) {
            return TriggerEventStreamsUtil.partitionFor(key, value, numPartitions);
        }
    };
    private static final StreamPartitioner<Object, Monitoring.MonitoringMessage> MONITORING_MESSAGE_PARTITIONER = new StreamPartitioner<Object, Monitoring.MonitoringMessage>(){

        public Integer partition(String topic, Object key, Monitoring.MonitoringMessage value, int numPartitions) {
            return MonitoringMessageUtil.partitionFor((Monitoring.MonitoringMessage)value, (int)numPartitions);
        }
    };
    private final MonitoringStreamExtension monitoringStreamExtension;
    private final GroupStreamExtension groupStreamExtension;
    private final ConsumerGroupStreamExtension consumerGroupStreamExtension;
    private final Set<StoreBuilder> storeBuilders;
    private final VerifyTransformerSupplier verifyTransformerSupplier;
    private final TopicStoreMaster.Store<Bytes, MonitoringVerifier, MonitoringVerifier> verifierStore;
    private final TopicStoreMaster.Topic<Void, Monitoring.MonitoringMessage, Void, Void> monitoringTopic;
    private final TopicStoreMaster.Topic<Void, Monitoring.MonitoringMessage, Void, Void> repartitionedMonitoringTopic;
    private final TopicStoreMaster.Topic<Controlcenter.WindowedClusterGroup, Monitoring.MonitoringMessage, Void, Void> rekeyedExpectedGroupConsumptionTopic;
    private final TopicStoreMaster.Topic<Controlcenter.WindowedClusterGroup, Monitoring.MonitoringMessage, Void, Void> rekeyedActualGroupConsumptionTopic;
    private final TopicStoreMaster.Topic<Controlcenter.WindowedClusterGroup, Controlcenter.TriggerMeasurement, Void, Void> metricsTriggerMeasurementTopic;
    private final TopicStoreMaster.Topic<Bytes, Controlcenter.TriggerEvent, Void, Void> rekeyedTriggerEventTopic;
    private final TopicStoreMaster.Topic<Void, ConfluentMetric.MetricsMessage, Void, Void> metricsTopic;
    private final TopicStoreMaster.Topic<?, MetricHolder, Void, Void> metricsAggregateRepartitionTopic;
    private final BroadcastHeartbeatTransformerSupplier<Void> broadcastHeartbeatTransformer;
    private final MetricToTriggerMeasurementTransformerSupplier metricToTriggerTransformerSupplier;
    private final MonitoringTriggerTransformerSupplier monitoringTriggerTransformerSupplier;
    private final TopicStoreMaster.Store<Bytes, Controlcenter.TriggerMeasurement, Controlcenter.TriggerMeasurement> monitoringTriggerStore;
    private final TopicStoreMaster.Store<Bytes, Controlcenter.TriggerActions, Controlcenter.TriggerActions> triggerActionsStore;
    private final TopicStoreMaster.Store<Bytes, Controlcenter.VerifiableTriggerInfo, Controlcenter.VerifiableTriggerInfo> triggerEventsStore;
    private final TopicStoreMaster.Store<Bytes, Alert.AlertInfo, Alert.AlertInfo> alertHistoryStore;
    private final TopicStoreMaster.Store<ByteBuffer, MetricHolder, MetricHolder> metricsAggregateStore;
    private final MetricsAggregation metricsAggregation;
    private final OrderedKeyPrefixedSerde<Keys.KeyType, Monitoring.MonitoringMessage> keySerde;
    private final GroupMeasurement groupMeasurement;
    private final AlertTransformerSupplier alertTransformerSupplier;
    private final AlertHistoryProcessorSupplier alertHistoryProcessorSupplier;
    private final KafkaClusterMetadataToCommandMapper kafkaClusterMetadataToCommandMapper;
    private final TopicStoreMaster.Topic<Command.CommandKey, Command.CommandMessage, Void, Void> commandTopic;
    private final LoadingCache<TokenCredential, Map<Integer, Long>> brokerCache;
    private final LoadingCache<TokenCredential, SortedSet<String>> topicCache;
    private final LoadingCache<TokenCredential, Map<String, Long>> topicPartitionCache;
    private final KafkaMetadataDao kafkaMetadataDao;
    private final AlertSenderRouter alertSenderRouter;
    private final KafkaVersionTracker kafkaVersionTracker;
    private final int metricsStoreRetentionDays;

    @Inject
    public StreamBuilderProvider(MonitoringStreamExtension monitoringStreamExtension, GroupStreamExtension groupStreamExtension, ConsumerGroupStreamExtension consumerGroupStreamExtension, Set<StoreBuilder> storeBuilders, VerifyTransformerSupplier verifyTransformerSupplier, @TopicStoreModule.VerifierStore TopicStoreMaster.Store<Bytes, MonitoringVerifier, MonitoringVerifier> verifierStore, @ControlCenterModule.MonitoringTopic TopicStoreMaster.Topic<Void, Monitoring.MonitoringMessage, Void, Void> monitoringTopic, @ControlCenterModule.MetricsTopic TopicStoreMaster.Topic<Void, ConfluentMetric.MetricsMessage, Void, Void> metricsTopic, @TopicStoreModule.ReKeyedMonitoringTopic TopicStoreMaster.Topic<Void, Monitoring.MonitoringMessage, Void, Void> repartitionedMonitoringTopic, @TopicStoreModule.ExpectedGroupConsumptionAggregateTopic TopicStoreMaster.Topic<Controlcenter.WindowedClusterGroup, Monitoring.MonitoringMessage, Void, Void> rekeyedExpectedGroupConsumptionTopic, @TopicStoreModule.ActualGroupConsumptionAggregateTopic TopicStoreMaster.Topic<Controlcenter.WindowedClusterGroup, Monitoring.MonitoringMessage, Void, Void> rekeyedActualGroupConsumptionTopic, BroadcastHeartbeatTransformerSupplier<Void> broadcastHeartbeatTransformer, MonitoringTriggerTransformerSupplier monitoringTriggerTransformerSupplier, MetricToTriggerMeasurementTransformerSupplier metricToTriggerTransformerSupplier, @TopicStoreModule.MonitoringTriggerStore TopicStoreMaster.Store<Bytes, Controlcenter.TriggerMeasurement, Controlcenter.TriggerMeasurement> monitoringTriggerStore, @TopicStoreModule.TriggerActionsStore TopicStoreMaster.Store<Bytes, Controlcenter.TriggerActions, Controlcenter.TriggerActions> triggerActionsStore, @TopicStoreModule.TriggerEventsStore TopicStoreMaster.Store<Bytes, Controlcenter.VerifiableTriggerInfo, Controlcenter.VerifiableTriggerInfo> triggerEventsStore, @TopicStoreModule.AlertHistoryStore TopicStoreMaster.Store<Bytes, Alert.AlertInfo, Alert.AlertInfo> alertHistoryStore, @TopicStoreModule.MetricsAggregateStore TopicStoreMaster.Store<ByteBuffer, MetricHolder, MetricHolder> metricsAggregateStore, @TopicStoreModule.MetricsAggregateRepartitionTopic TopicStoreMaster.Topic<?, MetricHolder, Void, Void> metricsAggregateRepartitionTopic, MetricsAggregation metricsAggregation, AlertTransformerSupplier alertTransformerSupplier, AlertHistoryProcessorSupplier alertHistoryProcessorSupplier, OrderedKeyPrefixedSerdeSupplier<Keys.KeyType, Monitoring.MonitoringMessage> keySerdeSupplier, GroupMeasurement groupMeasurement, @TopicStoreModule.ReKeyedTriggerEventTopic TopicStoreMaster.Topic<Bytes, Controlcenter.TriggerEvent, Void, Void> rekeyedTriggerEventTopic, TopicStoreMaster topicStoreMaster, @TopicStoreModule.MetricsTriggerMeasurementTopic TopicStoreMaster.Topic<Controlcenter.WindowedClusterGroup, Controlcenter.TriggerMeasurement, Void, Void> metricsTriggerMeasurementTopic, KafkaClusterMetadataToCommandMapper kafkaClusterMetadataToCommandMapper, @CommandModule.CommandTopic TopicStoreMaster.Topic<Command.CommandKey, Command.CommandMessage, Void, Void> commandTopic, @ControlCenterModule.BrokerCache LoadingCache<TokenCredential, Map<Integer, Long>> brokerCache, @ControlCenterModule.TopicCache LoadingCache<TokenCredential, SortedSet<String>> topicCache, @StreamsModule.TopicPartitionCache LoadingCache<TokenCredential, Map<String, Long>> topicPartitionCache, KafkaMetadataDao kafkaMetadataDao, AlertSenderRouter alertSenderRouter, KafkaVersionTracker kafkaVersionTracker, @ControlCenterModule.ControlCenterMetricsStoreRetentionDays int metricsStoreRetentionDays) {
        this.monitoringStreamExtension = monitoringStreamExtension;
        this.groupStreamExtension = groupStreamExtension;
        this.consumerGroupStreamExtension = consumerGroupStreamExtension;
        this.storeBuilders = storeBuilders;
        this.verifyTransformerSupplier = verifyTransformerSupplier;
        this.broadcastHeartbeatTransformer = broadcastHeartbeatTransformer;
        this.monitoringTopic = monitoringTopic;
        this.metricsTopic = metricsTopic;
        this.metricsAggregateRepartitionTopic = metricsAggregateRepartitionTopic;
        this.repartitionedMonitoringTopic = repartitionedMonitoringTopic;
        this.metricsAggregation = metricsAggregation;
        this.verifierStore = verifierStore;
        this.rekeyedActualGroupConsumptionTopic = rekeyedActualGroupConsumptionTopic;
        this.rekeyedExpectedGroupConsumptionTopic = rekeyedExpectedGroupConsumptionTopic;
        this.metricToTriggerTransformerSupplier = metricToTriggerTransformerSupplier;
        this.monitoringTriggerTransformerSupplier = monitoringTriggerTransformerSupplier;
        this.monitoringTriggerStore = monitoringTriggerStore;
        this.alertTransformerSupplier = alertTransformerSupplier;
        this.alertHistoryProcessorSupplier = alertHistoryProcessorSupplier;
        this.triggerActionsStore = triggerActionsStore;
        this.triggerEventsStore = triggerEventsStore;
        this.alertHistoryStore = alertHistoryStore;
        this.metricsAggregateStore = metricsAggregateStore;
        this.keySerde = keySerdeSupplier.get();
        this.groupMeasurement = groupMeasurement;
        this.rekeyedTriggerEventTopic = rekeyedTriggerEventTopic;
        this.metricsTriggerMeasurementTopic = metricsTriggerMeasurementTopic;
        this.kafkaClusterMetadataToCommandMapper = kafkaClusterMetadataToCommandMapper;
        this.commandTopic = commandTopic;
        this.brokerCache = brokerCache;
        this.topicCache = topicCache;
        this.topicPartitionCache = topicPartitionCache;
        this.kafkaMetadataDao = kafkaMetadataDao;
        this.alertSenderRouter = alertSenderRouter;
        this.kafkaVersionTracker = kafkaVersionTracker;
        this.metricsStoreRetentionDays = Math.max(1, metricsStoreRetentionDays);
    }

    public C3Streams.Builder get() {
        try {
            C3Streams.Builder builder = C3Streams.builder();
            C3Stream<K, V>[] branches = builder.withStoreBuilders(this.storeBuilders).stream(this.monitoringTopic).transformValues((ValueTransformerSupplier)new ValueTransformerSupplier<Monitoring.MonitoringMessage, Monitoring.MonitoringMessage>(){

                public ValueTransformer<Monitoring.MonitoringMessage, Monitoring.MonitoringMessage> get() {
                    return new InjectMonitoringPartitionTransformer();
                }
            }, new String[0]).transform(this.broadcastHeartbeatTransformer, new String[0]).flatMap(Identity.toFlatten()).through(MONITORING_MESSAGE_PARTITIONER, this.repartitionedMonitoringTopic).transform(this.verifyTransformerSupplier, new String[]{this.verifierStore.name}).flatMap(Identity.toFlatten()).branch((Predicate<? super K, ? super V>[])new Predicate[]{MonitoringPredicates.isNormal(), MonitoringPredicates.isError()});
            KStream input = branches[0].filter(MonitoringPredicates.hasWindow());
            KStream errorInput = branches[1].transform((TransformerSupplier)new TransformerSupplier<Void, Monitoring.MonitoringMessage, KeyValue<Void, Monitoring.MonitoringMessage>>(){

                public Transformer<Void, Monitoring.MonitoringMessage, KeyValue<Void, Monitoring.MonitoringMessage>> get() {
                    return new Transformer<Void, Monitoring.MonitoringMessage, KeyValue<Void, Monitoring.MonitoringMessage>>(){
                        ProcessorContext processorContext;

                        public void init(ProcessorContext context) {
                            this.processorContext = context;
                        }

                        public KeyValue<Void, Monitoring.MonitoringMessage> transform(Void key, Monitoring.MonitoringMessage value) {
                            this.processorContext.forward((Object)key, (Object)value, To.all().withTimestamp(value.getWindow()));
                            return KeyValue.pair((Object)key, (Object)value);
                        }

                        public void close() {
                        }
                    };
                }
            }, new String[0]);
            C3Stream<Void, Monitoring.MonitoringMessage> merged = builder.merge(input, errorInput);
            Map<Rollup, KTable<Windowed<Bytes>, Monitoring.MonitoringMessage>> expectedConsumptionAggr = this.consumerGroupStreamExtension.extend(merged);
            Map actualConsumptionAggr = this.monitoringStreamExtension.extend(merged);
            this.groupStreamExtension.extend(merged);
            merged.mapValues((ValueMapper)new ValueMapper<Monitoring.MonitoringMessage, CommandClusterMetadata.KafkaClusterMetadata>(){

                public CommandClusterMetadata.KafkaClusterMetadata apply(Monitoring.MonitoringMessage monitoringMessage) {
                    return CommandClusterMetadata.KafkaClusterMetadata.newBuilder().setClusterId(monitoringMessage.getClusterId()).build();
                }
            }).map(this.kafkaClusterMetadataToCommandMapper).filter(Predicates.keyNotNull()).to(this.commandTopic);
            C3Stream<Controlcenter.WindowedClusterGroup, Monitoring.MonitoringMessage> rekeyedCgExpectedConsumption = new C3Stream(expectedConsumptionAggr.get(RollupFactory.getOneMinuteRollup()).filter((Predicate)this.groupMeasurement).toStream((KeyValueMapper)new KeyValueMapper<Windowed<Bytes>, Monitoring.MonitoringMessage, Controlcenter.WindowedClusterGroup>(){

                public Controlcenter.WindowedClusterGroup apply(Windowed<Bytes> key, Monitoring.MonitoringMessage value) {
                    if (value != null) {
                        Monitoring.MonitoringMessage keyMm = (Monitoring.MonitoringMessage)StreamBuilderProvider.this.keySerde.toProto((Bytes)key.key());
                        return Controlcenter.WindowedClusterGroup.newBuilder().setClusterId(keyMm.getClusterId()).setComponent(keyMm.getGroup()).setMetricName("client-monitoring").setWindow(key.window().start()).build();
                    }
                    return Controlcenter.WindowedClusterGroup.newBuilder().setWindow(key.window().start()).build();
                }
            }), builder).filter(Predicates.valueNotNull()).through(this.rekeyedExpectedGroupConsumptionTopic);
            C3Stream<Controlcenter.WindowedClusterGroup, Monitoring.MonitoringMessage> rekeyedCgActualConsumption = new C3Stream(actualConsumptionAggr.get(RollupFactory.getOneMinuteRollup()).filter((Predicate)this.groupMeasurement).toStream((KeyValueMapper)new KeyValueMapper<Windowed<Bytes>, Monitoring.MonitoringMessage, Controlcenter.WindowedClusterGroup>(){

                public Controlcenter.WindowedClusterGroup apply(Windowed<Bytes> key, Monitoring.MonitoringMessage value) {
                    if (value != null) {
                        Monitoring.MonitoringMessage keyMm = (Monitoring.MonitoringMessage)StreamBuilderProvider.this.keySerde.toProto((Bytes)key.key());
                        return Controlcenter.WindowedClusterGroup.newBuilder().setClusterId(keyMm.getClusterId()).setComponent(keyMm.getGroup()).setMetricName("client-monitoring").setWindow(key.window().start()).build();
                    }
                    return Controlcenter.WindowedClusterGroup.newBuilder().setWindow(key.window().start()).build();
                }
            }), builder).filter(Predicates.valueNotNull()).through(this.rekeyedActualGroupConsumptionTopic);
            KStream metricsStream = builder.stream(this.metricsTopic).filter((Predicate)new Predicate<Void, ConfluentMetric.MetricsMessage>(){

                public boolean test(Void key, ConfluentMetric.MetricsMessage value) {
                    return value.getMetricType() == ConfluentMetric.MetricType.BROKER;
                }
            });
            metricsStream.mapValues((ValueMapper)new ValueMapper<ConfluentMetric.MetricsMessage, CommandClusterMetadata.KafkaClusterMetadata>(){

                public CommandClusterMetadata.KafkaClusterMetadata apply(ConfluentMetric.MetricsMessage metricsMessage) {
                    return CommandClusterMetadata.KafkaClusterMetadata.newBuilder().setClusterId(metricsMessage.getClusterId()).build();
                }
            }).map(this.kafkaClusterMetadataToCommandMapper).filter(Predicates.keyNotNull()).to(this.commandTopic);
            metricsStream.foreach((key, value) -> {
                try {
                    if (value.getClusterId() != null && value.getVersion() != null && value.getCommitId() != null) {
                        this.kafkaVersionTracker.register(value.getClusterId(), value.getBrokerId(), new BrokerVersion(value.getVersion(), value.getCommitId()));
                    }
                }
                catch (Exception e) {
                    log.debug("Failed to track a Kafka version", (Throwable)e);
                }
            });
            KStream alertableMetrics = metricsStream.mapValues(new MetricsExtractor(this.metricsAggregation.metricField(), this.brokerCache, this.topicCache, this.topicPartitionCache)).flatMap((KeyValueMapper)this.metricsAggregation.combiner()).groupBy(this.metricsAggregation.groupingSets(), this.metricsAggregateRepartitionTopic).windowedBy(MetricsAggregation.rollup()).aggregate(this.metricsAggregation.initializer(), this.metricsAggregation.aggregator(), Materialized.as((String)this.metricsAggregateStore.name).withKeySerde(this.metricsAggregation.groupingSets().keySerde()).withValueSerde(this.metricsAggregateStore.aggregateSerde).withRetention(Duration.ofDays(this.metricsStoreRetentionDays))).toStream().transform((TransformerSupplier)new TransformerSupplier<Windowed<? extends MetricEvent>, MetricValues, KeyValue<Windowed<MetricEvent>, MetricValues>>(){

                public Transformer<Windowed<? extends MetricEvent>, MetricValues, KeyValue<Windowed<MetricEvent>, MetricValues>> get() {
                    return new TransformCompositeMetrics(StreamBuilderProvider.this.metricsAggregation, StreamBuilderProvider.this.metricsAggregateStore, StreamBuilderProvider.this.kafkaMetadataDao);
                }
            }, new String[]{this.metricsAggregateStore.name});
            C3Stream<Controlcenter.WindowedClusterGroup, Controlcenter.TriggerMeasurement> metricMeasurementStream = new C3Stream(alertableMetrics, builder).transform(this.metricToTriggerTransformerSupplier, new String[0]).flatMap(Identity.toFlatten()).through(this.metricsTriggerMeasurementTopic);
            C3Stream<Controlcenter.WindowedClusterGroup, Controlcenter.TriggerMeasurement> monitoringMeasurementStream = rekeyedCgActualConsumption.outerJoin(rekeyedCgExpectedConsumption, new MonitoringTriggerMeasurementJoiner(), JoinWindows.of((Duration)Duration.ofMillis(1000L)), StreamJoined.with(this.rekeyedActualGroupConsumptionTopic.keySerde, this.rekeyedExpectedGroupConsumptionTopic.valueSerde, this.rekeyedActualGroupConsumptionTopic.valueSerde));
            C3Stream<Controlcenter.WindowedClusterGroup, Controlcenter.TriggerMeasurement> mergedMeasurementStream = builder.merge(monitoringMeasurementStream, metricMeasurementStream);
            KStream alertInfoKStream = mergedMeasurementStream.transform(this.monitoringTriggerTransformerSupplier, new String[]{this.monitoringTriggerStore.name}).flatMap(Identity.toFlatten()).through(TRIGGER_EVENT_PARTITIONER, this.rekeyedTriggerEventTopic).transform(this.alertTransformerSupplier, new String[]{this.triggerActionsStore.name, this.triggerEventsStore.name}).flatMap(Identity.toFlatten());
            alertInfoKStream.foreach(new ForeachAction<Alert.AlertInfo, Alert.AlertInfo>(){

                public void apply(Alert.AlertInfo key, Alert.AlertInfo value) {
                    StreamBuilderProvider.this.alertSenderRouter.sendWithHistory(value);
                }
            });
            alertInfoKStream.process(this.alertHistoryProcessorSupplier, this.alertHistoryStore.name);
            return builder;
        }
        catch (Throwable t) {
            log.error("creating streams", t);
            return null;
        }
    }
}

